/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.Exchange;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Intersect;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Minus;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Pair;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;

public class RelMdSize
implements MetadataHandler<BuiltInMetadata.Size> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((MetadataHandler)new RelMdSize(), BuiltInMethod.AVERAGE_COLUMN_SIZES.method, BuiltInMethod.AVERAGE_ROW_SIZE.method);
    public static final int BYTES_PER_CHARACTER = 2;

    protected RelMdSize() {
    }

    @Override
    public MetadataDef<BuiltInMetadata.Size> getDef() {
        return BuiltInMetadata.Size.DEF;
    }

    public Double averageRowSize(RelNode rel, RelMetadataQuery mq) {
        List<Double> averageColumnSizes = mq.getAverageColumnSizes(rel);
        if (averageColumnSizes == null) {
            return null;
        }
        double d = 0.0;
        List<RelDataTypeField> fields = rel.getRowType().getFieldList();
        for (Pair<Double, RelDataTypeField> p : Pair.zip(averageColumnSizes, fields)) {
            if (p.left == null) {
                d += this.averageFieldValueSize((RelDataTypeField)p.right).doubleValue();
                continue;
            }
            d += ((Double)p.left).doubleValue();
        }
        return d;
    }

    public List<Double> averageColumnSizes(RelNode rel, RelMetadataQuery mq) {
        return null;
    }

    public List<Double> averageColumnSizes(Filter rel, RelMetadataQuery mq) {
        return mq.getAverageColumnSizes(rel.getInput());
    }

    public List<Double> averageColumnSizes(Sort rel, RelMetadataQuery mq) {
        return mq.getAverageColumnSizes(rel.getInput());
    }

    public List<Double> averageColumnSizes(TableModify rel, RelMetadataQuery mq) {
        return mq.getAverageColumnSizes(rel.getInput());
    }

    public List<Double> averageColumnSizes(Exchange rel, RelMetadataQuery mq) {
        return mq.getAverageColumnSizes(rel.getInput());
    }

    public List<Double> averageColumnSizes(Project rel, RelMetadataQuery mq) {
        List<Double> inputColumnSizes = mq.getAverageColumnSizesNotNull(rel.getInput());
        ImmutableNullableList.Builder<Double> sizes = ImmutableNullableList.builder();
        for (RexNode project : rel.getProjects()) {
            sizes.add(this.averageRexSize(project, inputColumnSizes));
        }
        return sizes.build();
    }

    public List<Double> averageColumnSizes(Calc rel, RelMetadataQuery mq) {
        List<Double> inputColumnSizes = mq.getAverageColumnSizesNotNull(rel.getInput());
        ImmutableNullableList.Builder sizes = ImmutableNullableList.builder();
        ((ImmutableList)rel.getProgram().split().left).forEach(exp -> sizes.add(this.averageRexSize((RexNode)exp, inputColumnSizes)));
        return sizes.build();
    }

    public List<Double> averageColumnSizes(Values rel, RelMetadataQuery mq) {
        List<RelDataTypeField> fields = rel.getRowType().getFieldList();
        ImmutableList.Builder list = ImmutableList.builder();
        for (int i = 0; i < fields.size(); ++i) {
            double d;
            RelDataTypeField field = fields.get(i);
            if (rel.getTuples().isEmpty()) {
                d = this.averageTypeValueSize(field.getType());
            } else {
                d = 0.0;
                for (ImmutableList immutableList : rel.getTuples()) {
                    d += this.typeValueSize(field.getType(), ((RexLiteral)immutableList.get(i)).getValueAs(Comparable.class));
                }
                d /= (double)rel.getTuples().size();
            }
            list.add((Object)d);
        }
        return list.build();
    }

    public List<Double> averageColumnSizes(TableScan rel, RelMetadataQuery mq) {
        List<RelDataTypeField> fields = rel.getRowType().getFieldList();
        ImmutableList.Builder list = ImmutableList.builder();
        for (RelDataTypeField field : fields) {
            list.add(this.averageTypeValueSize(field.getType()));
        }
        return list.build();
    }

    public List<Double> averageColumnSizes(Aggregate rel, RelMetadataQuery mq) {
        List<Double> inputColumnSizes = mq.getAverageColumnSizesNotNull(rel.getInput());
        ImmutableList.Builder list = ImmutableList.builder();
        Iterator<Object> iterator = rel.getGroupSet().iterator();
        while (iterator.hasNext()) {
            int key = iterator.next();
            list.add(inputColumnSizes.get(key));
        }
        for (AggregateCall aggregateCall : rel.getAggCallList()) {
            list.add(this.averageTypeValueSize(aggregateCall.type));
        }
        return list.build();
    }

    public List<Double> averageColumnSizes(Join rel, RelMetadataQuery mq) {
        return this.averageJoinColumnSizes(rel, mq);
    }

    private List<Double> averageJoinColumnSizes(Join rel, RelMetadataQuery mq) {
        List<Double> rights;
        boolean semiOrAntijoin = !rel.getJoinType().projectsRight();
        RelNode left = rel.getLeft();
        RelNode right = rel.getRight();
        List<Double> lefts = mq.getAverageColumnSizes(left);
        List<Double> list = rights = semiOrAntijoin ? null : mq.getAverageColumnSizes(right);
        if (lefts == null && rights == null) {
            return null;
        }
        int fieldCount = rel.getRowType().getFieldCount();
        Double[] sizes = new Double[fieldCount];
        if (lefts != null) {
            lefts.toArray(sizes);
        }
        if (rights != null) {
            int leftCount = left.getRowType().getFieldCount();
            for (int i = 0; i < rights.size(); ++i) {
                sizes[leftCount + i] = rights.get(i);
            }
        }
        return ImmutableNullableList.copyOf(sizes);
    }

    public List<Double> averageColumnSizes(Intersect rel, RelMetadataQuery mq) {
        return mq.getAverageColumnSizes(rel.getInput(0));
    }

    public List<Double> averageColumnSizes(Minus rel, RelMetadataQuery mq) {
        return mq.getAverageColumnSizes(rel.getInput(0));
    }

    public List<Double> averageColumnSizes(Union rel, RelMetadataQuery mq) {
        int fieldCount = rel.getRowType().getFieldCount();
        ArrayList<List<Double>> inputColumnSizeList = new ArrayList<List<Double>>();
        for (RelNode input : rel.getInputs()) {
            List<Double> inputSizes = mq.getAverageColumnSizes(input);
            if (inputSizes == null) continue;
            inputColumnSizeList.add(inputSizes);
        }
        switch (inputColumnSizeList.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (List)inputColumnSizeList.get(0);
            }
        }
        ImmutableNullableList.Builder<Double> sizes = ImmutableNullableList.builder();
        int nn = 0;
        for (int i = 0; i < fieldCount; ++i) {
            double d = 0.0;
            int n = 0;
            for (List list : inputColumnSizeList) {
                Double d2 = (Double)list.get(i);
                if (d2 == null) continue;
                d += d2.doubleValue();
                ++n;
                ++nn;
            }
            sizes.add(n > 0 ? Double.valueOf(d / (double)n) : null);
        }
        if (nn == 0) {
            return null;
        }
        return sizes.build();
    }

    protected Double averageFieldValueSize(RelDataTypeField field) {
        return this.averageTypeValueSize(field.getType());
    }

    public Double averageTypeValueSize(RelDataType type) {
        switch (type.getSqlTypeName()) {
            case BOOLEAN: 
            case TINYINT: {
                return 1.0;
            }
            case SMALLINT: {
                return 2.0;
            }
            case INTEGER: 
            case REAL: 
            case DECIMAL: 
            case DATE: 
            case TIME: 
            case TIME_WITH_LOCAL_TIME_ZONE: 
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: {
                return 4.0;
            }
            case BIGINT: 
            case DOUBLE: 
            case FLOAT: 
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                return 8.0;
            }
            case BINARY: {
                return type.getPrecision();
            }
            case VARBINARY: {
                return Math.min((double)type.getPrecision(), 100.0);
            }
            case CHAR: {
                return (double)type.getPrecision() * 2.0;
            }
            case VARCHAR: {
                return Math.min((double)type.getPrecision() * 2.0, 100.0);
            }
            case ROW: {
                double average = 0.0;
                for (RelDataTypeField field : type.getFieldList()) {
                    average += this.averageTypeValueSize(field.getType()).doubleValue();
                }
                return average;
            }
        }
        return null;
    }

    public double typeValueSize(RelDataType type, Comparable value) {
        if (value == null) {
            return 1.0;
        }
        switch (type.getSqlTypeName()) {
            case BOOLEAN: 
            case TINYINT: {
                return 1.0;
            }
            case SMALLINT: {
                return 2.0;
            }
            case INTEGER: 
            case REAL: 
            case DATE: 
            case TIME: 
            case TIME_WITH_LOCAL_TIME_ZONE: 
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: 
            case FLOAT: {
                return 4.0;
            }
            case BIGINT: 
            case DOUBLE: 
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                return 8.0;
            }
            case BINARY: 
            case VARBINARY: {
                return ((ByteString)value).length();
            }
            case CHAR: 
            case VARCHAR: {
                return ((NlsString)value).getValue().length() * 2;
            }
        }
        return 32.0;
    }

    public Double averageRexSize(RexNode node, List<Double> inputColumnSizes) {
        switch (node.getKind()) {
            case INPUT_REF: {
                return inputColumnSizes.get(((RexInputRef)node).getIndex());
            }
            case LITERAL: {
                return this.typeValueSize(node.getType(), ((RexLiteral)node).getValueAs(Comparable.class));
            }
        }
        if (node instanceof RexCall) {
            RexCall call = (RexCall)node;
            for (RexNode operand : call.getOperands()) {
                if (operand.getType().getSqlTypeName() != node.getType().getSqlTypeName()) continue;
                return this.averageRexSize(operand, inputColumnSizes);
            }
        }
        return this.averageTypeValueSize(node.getType());
    }
}

