/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rel.type.RelDataTypePrecedenceList;
import org.apache.calcite.sql.type.SqlTypeExplicitPrecedenceList;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;

public abstract class AbstractSqlType
extends RelDataTypeImpl
implements Cloneable,
Serializable {
    protected final SqlTypeName typeName;
    protected boolean isNullable;

    protected AbstractSqlType(SqlTypeName typeName, boolean isNullable, List<? extends RelDataTypeField> fields) {
        super(fields);
        this.typeName = Objects.requireNonNull(typeName);
        this.isNullable = isNullable || typeName == SqlTypeName.NULL;
    }

    @Override
    public SqlTypeName getSqlTypeName() {
        return this.typeName;
    }

    @Override
    public boolean isNullable() {
        return this.isNullable;
    }

    @Override
    public RelDataTypeFamily getFamily() {
        SqlTypeFamily family = this.typeName.getFamily();
        return family != null ? family : this;
    }

    @Override
    public RelDataTypePrecedenceList getPrecedenceList() {
        RelDataTypePrecedenceList list = SqlTypeExplicitPrecedenceList.getListForType(this);
        if (list != null) {
            return list;
        }
        return super.getPrecedenceList();
    }
}

