/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.calcite;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.runtime.FlatLists;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.Sarg;
import org.apache.calcite.util.TimestampString;
import org.apache.calcite.util.Util;
import org.apache.flink.calcite.shaded.com.google.common.collect.Range;
import org.apache.flink.calcite.shaded.com.google.common.collect.TreeRangeSet;
import org.apache.flink.shaded.guava30.com.google.common.collect.ImmutableList;

public final class FlinkRexBuilder
extends RexBuilder {
    public FlinkRexBuilder(RelDataTypeFactory typeFactory) {
        super(typeFactory);
    }

    @Override
    public RexNode makeFieldAccess(RexNode expr, String fieldName, boolean caseSensitive) {
        RexNode field = super.makeFieldAccess(expr, fieldName, caseSensitive);
        if (expr.getType().isNullable() && !field.getType().isNullable()) {
            return this.makeCast(this.typeFactory.createTypeWithNullability(field.getType(), true), field, true);
        }
        return field;
    }

    @Override
    public RexNode makeFieldAccess(RexNode expr, int i) {
        RexNode field = super.makeFieldAccess(expr, i);
        if (expr.getType().isNullable() && !field.getType().isNullable()) {
            return this.makeCast(this.typeFactory.createTypeWithNullability(field.getType(), true), field, true);
        }
        return field;
    }

    @Override
    public RexNode makeZeroLiteral(RelDataType type) {
        switch (type.getSqlTypeName()) {
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return this.makeLiteral((Object)new TimestampString(1970, 1, 1, 0, 0, 0), type, false);
            }
        }
        return super.makeZeroLiteral(type);
    }

    @Override
    public RexNode makeIn(RexNode arg, List<? extends RexNode> ranges) {
        if (this.areAssignable(arg, ranges)) {
            ArrayList<RexNode> rangeWithoutNull = new ArrayList<RexNode>();
            boolean containsNull = false;
            for (RexNode rexNode : ranges) {
                if (this.isNull(rexNode)) {
                    containsNull = true;
                    continue;
                }
                rangeWithoutNull.add(rexNode);
            }
            Sarg<Comparable> sarg = FlinkRexBuilder.toSarg(Comparable.class, rangeWithoutNull, containsNull);
            if (sarg != null) {
                List<RelDataType> list = Util.distinctList(ranges.stream().map(RexNode::getType).collect(Collectors.toList()));
                RelDataType commonType = this.getTypeFactory().leastRestrictive(list);
                return this.makeCall((SqlOperator)SqlStdOperatorTable.SEARCH, arg, this.makeSearchArgumentLiteral(sarg, commonType));
            }
        }
        return RexUtil.composeDisjunction(this, ranges.stream().map(r -> this.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, arg, (RexNode)r)).collect(Util.toImmutableList()));
    }

    private boolean isNull(RexNode node) {
        if (node instanceof RexLiteral) {
            return ((RexLiteral)node).isNull();
        }
        return false;
    }

    private boolean areAssignable(RexNode arg, List<? extends RexNode> bounds) {
        for (RexNode rexNode : bounds) {
            if (SqlTypeUtil.inSameFamily(arg.getType(), rexNode.getType()) || arg.getType().isStruct() && rexNode.getType().isStruct()) continue;
            return false;
        }
        return true;
    }

    private static <C extends Comparable<C>> Sarg<C> toSarg(Class<C> clazz, List<? extends RexNode> ranges, boolean containsNull) {
        if (ranges.isEmpty()) {
            return null;
        }
        TreeRangeSet<C> rangeSet = TreeRangeSet.create();
        for (RexNode rexNode : ranges) {
            C value = FlinkRexBuilder.toComparable(clazz, rexNode);
            if (value == null) {
                return null;
            }
            rangeSet.add(Range.singleton(value));
        }
        return Sarg.of(containsNull, rangeSet);
    }

    private static <C extends Comparable<C>> C toComparable(Class<C> clazz, RexNode point) {
        switch (point.getKind()) {
            case LITERAL: {
                RexLiteral literal = (RexLiteral)point;
                return (C)((Comparable)literal.getValueAs(clazz));
            }
            case ROW: {
                RexCall call = (RexCall)point;
                ImmutableList.Builder b = ImmutableList.builder();
                for (RexNode operand : call.operands) {
                    Comparable value = FlinkRexBuilder.toComparable(Comparable.class, operand);
                    if (value == null) {
                        return null;
                    }
                    b.add((Object)value);
                }
                return (C)((Comparable)clazz.cast(FlatLists.ofComparable(b.build())));
            }
        }
        return null;
    }
}

