/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.bridging;

import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.Optionality;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.ContextResolvedFunction;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.functions.FunctionRequirement;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.functions.bridging.BridgingUtils;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.util.Preconditions;

@Internal
public final class BridgingSqlAggFunction
extends SqlAggFunction {
    private final DataTypeFactory dataTypeFactory;
    private final FlinkTypeFactory typeFactory;
    private final ContextResolvedFunction resolvedFunction;
    private final TypeInference typeInference;
    private final List<RelDataType> paramTypes;

    private BridgingSqlAggFunction(DataTypeFactory dataTypeFactory, FlinkTypeFactory typeFactory, SqlKind kind, ContextResolvedFunction resolvedFunction, TypeInference typeInference) {
        super(BridgingUtils.createName(resolvedFunction), BridgingUtils.createSqlIdentifier(resolvedFunction), kind, BridgingUtils.createSqlReturnTypeInference(dataTypeFactory, resolvedFunction.getDefinition(), typeInference), BridgingUtils.createSqlOperandTypeInference(dataTypeFactory, resolvedFunction.getDefinition(), typeInference), BridgingUtils.createSqlOperandTypeChecker(dataTypeFactory, resolvedFunction.getDefinition(), typeInference), BridgingUtils.createSqlFunctionCategory(resolvedFunction), BridgingSqlAggFunction.createOrderRequirement(), BridgingSqlAggFunction.createOverWindowRequirement(resolvedFunction.getDefinition()), BridgingSqlAggFunction.createGroupOrderRequirement());
        this.dataTypeFactory = dataTypeFactory;
        this.typeFactory = typeFactory;
        this.resolvedFunction = resolvedFunction;
        this.typeInference = typeInference;
        this.paramTypes = BridgingUtils.createParamTypes(typeFactory, typeInference);
    }

    public static BridgingSqlAggFunction of(DataTypeFactory dataTypeFactory, FlinkTypeFactory typeFactory, SqlKind kind, ContextResolvedFunction resolvedFunction, TypeInference typeInference) {
        FunctionKind functionKind = resolvedFunction.getDefinition().getKind();
        Preconditions.checkState((functionKind == FunctionKind.AGGREGATE || functionKind == FunctionKind.TABLE_AGGREGATE ? 1 : 0) != 0, (Object)"Aggregating function kind expected.");
        return new BridgingSqlAggFunction(dataTypeFactory, typeFactory, kind, resolvedFunction, typeInference);
    }

    public static BridgingSqlAggFunction of(FlinkContext context, FlinkTypeFactory typeFactory, ContextResolvedFunction resolvedFunction) {
        DataTypeFactory dataTypeFactory = context.getCatalogManager().getDataTypeFactory();
        TypeInference typeInference = resolvedFunction.getDefinition().getTypeInference(dataTypeFactory);
        return BridgingSqlAggFunction.of(dataTypeFactory, typeFactory, SqlKind.OTHER_FUNCTION, resolvedFunction, typeInference);
    }

    public DataTypeFactory getDataTypeFactory() {
        return this.dataTypeFactory;
    }

    public FlinkTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public ContextResolvedFunction getResolvedFunction() {
        return this.resolvedFunction;
    }

    public FunctionDefinition getDefinition() {
        return this.resolvedFunction.getDefinition();
    }

    public TypeInference getTypeInference() {
        return this.typeInference;
    }

    @Override
    public List<RelDataType> getParamTypes() {
        return this.paramTypes;
    }

    @Override
    public List<String> getParamNames() {
        if (this.typeInference.getNamedArguments().isPresent()) {
            return (List)this.typeInference.getNamedArguments().get();
        }
        return super.getParamNames();
    }

    @Override
    public boolean isDeterministic() {
        return this.resolvedFunction.getDefinition().isDeterministic();
    }

    private static boolean createOrderRequirement() {
        return false;
    }

    private static boolean createOverWindowRequirement(FunctionDefinition definition) {
        return definition.getRequirements().contains(FunctionRequirement.OVER_WINDOW_ONLY);
    }

    private static Optionality createGroupOrderRequirement() {
        return Optionality.FORBIDDEN;
    }
}

