/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.utils.CastExecutor;
import org.apache.flink.table.planner.functions.casting.ArrayToArrayCastRule;
import org.apache.flink.table.planner.functions.casting.ArrayToStringCastRule;
import org.apache.flink.table.planner.functions.casting.BinaryToBinaryCastRule;
import org.apache.flink.table.planner.functions.casting.BinaryToStringCastRule;
import org.apache.flink.table.planner.functions.casting.BooleanToNumericCastRule;
import org.apache.flink.table.planner.functions.casting.BooleanToStringCastRule;
import org.apache.flink.table.planner.functions.casting.CastCodeBlock;
import org.apache.flink.table.planner.functions.casting.CastRule;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.planner.functions.casting.CharVarCharTrimPadCastRule;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.DateToStringCastRule;
import org.apache.flink.table.planner.functions.casting.DateToTimestampCastRule;
import org.apache.flink.table.planner.functions.casting.DecimalToDecimalCastRule;
import org.apache.flink.table.planner.functions.casting.DecimalToNumericPrimitiveCastRule;
import org.apache.flink.table.planner.functions.casting.IdentityCastRule;
import org.apache.flink.table.planner.functions.casting.IntervalToStringCastRule;
import org.apache.flink.table.planner.functions.casting.MapAndMultisetToStringCastRule;
import org.apache.flink.table.planner.functions.casting.MapToMapAndMultisetToMultisetCastRule;
import org.apache.flink.table.planner.functions.casting.NullToStringCastRule;
import org.apache.flink.table.planner.functions.casting.NumericPrimitiveCastRule;
import org.apache.flink.table.planner.functions.casting.NumericPrimitiveToDecimalCastRule;
import org.apache.flink.table.planner.functions.casting.NumericToBooleanCastRule;
import org.apache.flink.table.planner.functions.casting.NumericToStringCastRule;
import org.apache.flink.table.planner.functions.casting.NumericToTimestampCastRule;
import org.apache.flink.table.planner.functions.casting.RawToBinaryCastRule;
import org.apache.flink.table.planner.functions.casting.RawToStringCastRule;
import org.apache.flink.table.planner.functions.casting.RowToRowCastRule;
import org.apache.flink.table.planner.functions.casting.RowToStringCastRule;
import org.apache.flink.table.planner.functions.casting.StringToBinaryCastRule;
import org.apache.flink.table.planner.functions.casting.StringToBooleanCastRule;
import org.apache.flink.table.planner.functions.casting.StringToDateCastRule;
import org.apache.flink.table.planner.functions.casting.StringToDecimalCastRule;
import org.apache.flink.table.planner.functions.casting.StringToNumericPrimitiveCastRule;
import org.apache.flink.table.planner.functions.casting.StringToTimeCastRule;
import org.apache.flink.table.planner.functions.casting.StringToTimestampCastRule;
import org.apache.flink.table.planner.functions.casting.StructuredToStringCastRule;
import org.apache.flink.table.planner.functions.casting.TimeToStringCastRule;
import org.apache.flink.table.planner.functions.casting.TimeToTimestampCastRule;
import org.apache.flink.table.planner.functions.casting.TimestampToDateCastRule;
import org.apache.flink.table.planner.functions.casting.TimestampToNumericCastRule;
import org.apache.flink.table.planner.functions.casting.TimestampToStringCastRule;
import org.apache.flink.table.planner.functions.casting.TimestampToTimeCastRule;
import org.apache.flink.table.planner.functions.casting.TimestampToTimestampCastRule;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.NullType;
import org.apache.flink.util.Preconditions;

@Internal
public class CastRuleProvider {
    private static final CastRuleProvider INSTANCE = new CastRuleProvider();
    private final Map<Object, Map<Object, CastRule<?, ?>>> rules = new HashMap();
    private final List<CastRule<?, ?>> rulesWithCustomPredicate = new ArrayList();

    @Nullable
    public static CastRule<?, ?> resolve(LogicalType inputType, LogicalType targetType) {
        return INSTANCE.internalResolve(inputType, targetType);
    }

    public static boolean exists(LogicalType inputType, LogicalType targetType) {
        return CastRuleProvider.resolve(inputType, targetType) != null;
    }

    public static boolean canFail(LogicalType inputType, LogicalType targetType) {
        return ((CastRule)Preconditions.checkNotNull(CastRuleProvider.resolve(inputType, targetType), (String)"Cast rule cannot be resolved")).canFail(inputType, targetType);
    }

    @Nullable
    public static CastExecutor<?, ?> create(CastRule.Context context, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        CastRule<?, ?> rule = INSTANCE.internalResolve(inputLogicalType, targetLogicalType);
        if (rule == null) {
            return null;
        }
        return rule.create(context, inputLogicalType, targetLogicalType);
    }

    @Nullable
    public static CastCodeBlock generateCodeBlock(CodeGeneratorCastRule.Context context, String inputTerm, String inputIsNullTerm, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        CastRule<?, ?> rule = INSTANCE.internalResolve(inputLogicalType, targetLogicalType);
        if (!(rule instanceof CodeGeneratorCastRule)) {
            return null;
        }
        return ((CodeGeneratorCastRule)rule).generateCodeBlock(context, inputTerm, inputIsNullTerm, inputLogicalType, targetLogicalType);
    }

    @Nullable
    public static Object cast(CastRule.Context context, LogicalType inputLogicalType, LogicalType targetLogicalType, Object value) {
        CastExecutor<?, ?> castExecutor = CastRuleProvider.create(context, inputLogicalType, targetLogicalType);
        if (castExecutor == null) {
            throw new NullPointerException("Unsupported casting from " + inputLogicalType + " to " + targetLogicalType);
        }
        return castExecutor.cast(value);
    }

    static CastCodeBlock generateAlwaysNonNullCodeBlock(CodeGeneratorCastRule.Context context, String inputTerm, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        if (inputLogicalType instanceof NullType) {
            return CastRuleProvider.generateCodeBlock(context, inputTerm, "true", inputLogicalType, targetLogicalType);
        }
        return CastRuleProvider.generateCodeBlock(context, inputTerm, "false", inputLogicalType.copy(false), targetLogicalType);
    }

    private CastRuleProvider addRule(CastRule<?, ?> rule) {
        Map map;
        CastRulePredicate predicate = rule.getPredicateDefinition();
        for (LogicalType targetType : predicate.getTargetTypes()) {
            map = this.rules.computeIfAbsent(targetType, k -> new HashMap());
            for (LogicalTypeRoot inputTypeRoot : predicate.getInputTypeRoots()) {
                map.put(inputTypeRoot, rule);
            }
            for (LogicalTypeFamily inputTypeFamily : predicate.getInputTypeFamilies()) {
                map.put(inputTypeFamily, rule);
            }
        }
        for (LogicalTypeRoot targetTypeRoot : predicate.getTargetTypeRoots()) {
            map = this.rules.computeIfAbsent(targetTypeRoot, k -> new HashMap());
            for (LogicalTypeRoot inputTypeRoot : predicate.getInputTypeRoots()) {
                map.put(inputTypeRoot, rule);
            }
            for (LogicalTypeFamily inputTypeFamily : predicate.getInputTypeFamilies()) {
                map.put(inputTypeFamily, rule);
            }
        }
        for (LogicalTypeFamily targetTypeFamily : predicate.getTargetTypeFamilies()) {
            map = this.rules.computeIfAbsent(targetTypeFamily, k -> new HashMap());
            for (LogicalTypeRoot inputTypeRoot : predicate.getInputTypeRoots()) {
                map.put(inputTypeRoot, rule);
            }
            for (LogicalTypeFamily inputTypeFamily : predicate.getInputTypeFamilies()) {
                map.put(inputTypeFamily, rule);
            }
        }
        if (predicate.getCustomPredicate().isPresent()) {
            this.rulesWithCustomPredicate.add(rule);
        }
        return this;
    }

    private CastRule<?, ?> internalResolve(LogicalType input, LogicalType target) {
        LogicalType inputType = this.unwrapDistinct(input);
        LogicalType targetType = this.unwrapDistinct(target);
        Iterator targetTypeRootFamilyIterator = Stream.concat(Stream.of(targetType), Stream.concat(Stream.of(targetType.getTypeRoot()), targetType.getTypeRoot().getFamilies().stream())).iterator();
        while (targetTypeRootFamilyIterator.hasNext()) {
            Optional<CastRule> rule;
            Object targetMapKey = targetTypeRootFamilyIterator.next();
            Map<Object, CastRule<?, ?>> inputTypeToCastRuleMap = this.rules.get(targetMapKey);
            if (inputTypeToCastRuleMap == null || !(rule = Stream.concat(Stream.of(inputType.getTypeRoot()), inputType.getTypeRoot().getFamilies().stream()).map(inputTypeToCastRuleMap::get).filter(Objects::nonNull).findFirst()).isPresent()) continue;
            return rule.get();
        }
        return this.rulesWithCustomPredicate.stream().filter(r -> r.getPredicateDefinition().getCustomPredicate().map(p -> p.test(inputType, targetType)).orElse(false)).findFirst().orElse(null);
    }

    private LogicalType unwrapDistinct(LogicalType logicalType) {
        if (logicalType.is(LogicalTypeRoot.DISTINCT_TYPE)) {
            return this.unwrapDistinct(((DistinctType)logicalType).getSourceType());
        }
        return logicalType;
    }

    static {
        INSTANCE.addRule(DecimalToDecimalCastRule.INSTANCE).addRule(NumericPrimitiveToDecimalCastRule.INSTANCE).addRule(DecimalToNumericPrimitiveCastRule.INSTANCE).addRule(NumericPrimitiveCastRule.INSTANCE).addRule(BooleanToNumericCastRule.INSTANCE).addRule(NumericToBooleanCastRule.INSTANCE).addRule(NumericToStringCastRule.INSTANCE).addRule(BooleanToStringCastRule.INSTANCE).addRule(BinaryToStringCastRule.INSTANCE).addRule(TimestampToStringCastRule.INSTANCE).addRule(TimeToStringCastRule.INSTANCE).addRule(DateToStringCastRule.INSTANCE).addRule(IntervalToStringCastRule.INSTANCE).addRule(ArrayToStringCastRule.INSTANCE).addRule(MapAndMultisetToStringCastRule.INSTANCE).addRule(StructuredToStringCastRule.INSTANCE).addRule(RowToStringCastRule.INSTANCE).addRule(RawToStringCastRule.INSTANCE).addRule(StringToBooleanCastRule.INSTANCE).addRule(StringToDecimalCastRule.INSTANCE).addRule(StringToNumericPrimitiveCastRule.INSTANCE).addRule(StringToDateCastRule.INSTANCE).addRule(StringToTimeCastRule.INSTANCE).addRule(StringToTimestampCastRule.INSTANCE).addRule(StringToBinaryCastRule.INSTANCE).addRule(TimestampToTimestampCastRule.INSTANCE).addRule(TimestampToDateCastRule.INSTANCE).addRule(TimestampToTimeCastRule.INSTANCE).addRule(DateToTimestampCastRule.INSTANCE).addRule(TimeToTimestampCastRule.INSTANCE).addRule(NumericToTimestampCastRule.INSTANCE).addRule(TimestampToNumericCastRule.INSTANCE).addRule(BinaryToBinaryCastRule.INSTANCE).addRule(RawToBinaryCastRule.INSTANCE).addRule(ArrayToArrayCastRule.INSTANCE).addRule(MapToMapAndMultisetToMultisetCastRule.INSTANCE).addRule(RowToRowCastRule.INSTANCE).addRule(CharVarCharTrimPadCastRule.INSTANCE).addRule(NullToStringCastRule.INSTANCE).addRule(IdentityCastRule.INSTANCE);
    }
}

