/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.abilities.sink;

import java.util.Objects;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.abilities.SupportsOverwrite;
import org.apache.flink.table.planner.plan.abilities.sink.SinkAbilitySpec;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeName(value="Overwrite")
public final class OverwriteSpec
implements SinkAbilitySpec {
    public static final String FIELD_NAME_OVERWRITE = "overwrite";
    @JsonProperty(value="overwrite")
    private final boolean overwrite;

    @JsonCreator
    public OverwriteSpec(@JsonProperty(value="overwrite") boolean overwrite) {
        this.overwrite = overwrite;
    }

    @Override
    public void apply(DynamicTableSink tableSink) {
        if (!(tableSink instanceof SupportsOverwrite)) {
            throw new TableException(String.format("%s does not support SupportsOverwrite.", tableSink.getClass().getName()));
        }
        ((SupportsOverwrite)tableSink).applyOverwrite(this.overwrite);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OverwriteSpec that = (OverwriteSpec)o;
        return this.overwrite == that.overwrite;
    }

    public int hashCode() {
        return Objects.hash(this.overwrite);
    }
}

