/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.batch;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.source.InputFormatSourceFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.common.CommonExecLegacyTableSourceScan;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.ScanUtil;
import org.apache.flink.table.planner.sources.TableSourceUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import scala.Function1;
import scala.Function2;

public class BatchExecLegacyTableSourceScan
extends CommonExecLegacyTableSourceScan
implements BatchExecNode<RowData> {
    public BatchExecLegacyTableSourceScan(ReadableConfig tableConfig, TableSource<?> tableSource, List<String> qualifiedName, RowType outputType, String description) {
        super(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(BatchExecLegacyTableSourceScan.class), ExecNodeContext.newPersistedConfig(BatchExecLegacyTableSourceScan.class, tableConfig), tableSource, qualifiedName, outputType, description);
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        Transformation<RowData> transformation = super.translateToPlanInternal(planner, config);
        ExecNodeUtil.makeLegacySourceTransformationsBounded(transformation);
        return transformation;
    }

    @Override
    protected Transformation<RowData> createConversionTransformationIfNeeded(StreamExecutionEnvironment streamExecEnv, ExecNodeConfig config, Transformation<?> sourceTransform, @Nullable RexNode rowtimeExpression) {
        int[] fieldIndexes = this.computeIndexMapping(false);
        if (this.needInternalConversion(fieldIndexes)) {
            DataType fixedProducedDataType = TableSourceUtil.fixPrecisionForProducedDataType(this.tableSource, (RowType)this.getOutputType());
            return ScanUtil.convertToInternalRow(new CodeGeneratorContext(config.getTableConfig()), sourceTransform, fieldIndexes, fixedProducedDataType, (RowType)this.getOutputType(), this.qualifiedName, (Function2<String, String, String>)((Function2)(detailName, simplifyName) -> this.createFormattedTransformationName((String)detailName, (String)simplifyName, config)), (Function1<String, String>)((Function1)description -> this.createFormattedTransformationDescription((String)description, config)), JavaScalaConversionUtil.toScala(Optional.ofNullable(rowtimeExpression)), "", "");
        }
        return sourceTransform;
    }

    @Override
    protected <IN> Transformation<IN> createInput(StreamExecutionEnvironment env, InputFormat<IN, ? extends InputSplit> inputFormat, TypeInformation<IN> typeInfo) {
        InputFormatSourceFunction function = new InputFormatSourceFunction(inputFormat, typeInfo);
        return env.addSource((SourceFunction)function, this.tableSource.explainSource(), typeInfo).getTransformation();
    }
}

