/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.common;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.MultipleTransformationTranslator;
import org.apache.flink.table.planner.plan.utils.ScanUtil;
import org.apache.flink.table.planner.sources.TableSourceUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.runtime.types.TypeInfoDataTypeConverter;
import org.apache.flink.table.sources.DefinedFieldMapping;
import org.apache.flink.table.sources.InputFormatTableSource;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.utils.TypeMappingUtils;

public abstract class CommonExecLegacyTableSourceScan
extends ExecNodeBase<RowData>
implements MultipleTransformationTranslator<RowData> {
    protected final TableSource<?> tableSource;
    protected final List<String> qualifiedName;

    public CommonExecLegacyTableSourceScan(int id, ExecNodeContext context, ReadableConfig persistedConfig, TableSource<?> tableSource, List<String> qualifiedName, RowType outputType, String description) {
        super(id, context, persistedConfig, Collections.emptyList(), (LogicalType)outputType, description);
        this.tableSource = tableSource;
        this.qualifiedName = qualifiedName;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        Transformation sourceTransform;
        StreamExecutionEnvironment env = planner.getExecEnv();
        if (this.tableSource instanceof InputFormatTableSource) {
            InputFormatTableSource inputFormat = (InputFormatTableSource)this.tableSource;
            TypeInformation typeInfo = TypeInfoDataTypeConverter.fromDataTypeToTypeInfo((DataType)inputFormat.getProducedDataType());
            InputFormat format = inputFormat.getInputFormat();
            sourceTransform = this.createInput(env, format, typeInfo);
        } else if (this.tableSource instanceof StreamTableSource) {
            sourceTransform = ((StreamTableSource)this.tableSource).getDataStream(env).getTransformation();
        } else {
            throw new UnsupportedOperationException(this.tableSource.getClass().getSimpleName() + " is unsupported.");
        }
        TypeInformation inputType = sourceTransform.getOutputType();
        DataType producedDataType = this.tableSource.getProducedDataType();
        if (!inputType.equals((Object)TypeInfoDataTypeConverter.fromDataTypeToTypeInfo((DataType)producedDataType))) {
            throw new TableException(String.format("TableSource of type %s returned a DataStream of data type %s that does not match with the data type %s declared by the TableSource.getProducedDataType() method. Please validate the implementation of the TableSource.", this.tableSource.getClass().getCanonicalName(), inputType, producedDataType));
        }
        RowType outputType = (RowType)this.getOutputType();
        RelDataType relDataType = FlinkTypeFactory.INSTANCE().buildRelNodeRowType(outputType);
        Optional<RexNode> rowtimeExpression = JavaScalaConversionUtil.toJava(TableSourceUtil.getRowtimeAttributeDescriptor(this.tableSource, relDataType)).map(desc -> TableSourceUtil.getRowtimeExtractionExpression(desc.getTimestampExtractor(), producedDataType, planner.getRelBuilder(), this.getNameRemapping()));
        return this.createConversionTransformationIfNeeded(planner.getExecEnv(), config, sourceTransform, rowtimeExpression.orElse(null));
    }

    protected abstract <IN> Transformation<IN> createInput(StreamExecutionEnvironment var1, InputFormat<IN, ? extends InputSplit> var2, TypeInformation<IN> var3);

    protected abstract Transformation<RowData> createConversionTransformationIfNeeded(StreamExecutionEnvironment var1, ExecNodeConfig var2, Transformation<?> var3, @Nullable RexNode var4);

    protected boolean needInternalConversion(int[] fieldIndexes) {
        return ScanUtil.hasTimeAttributeField(fieldIndexes) || ScanUtil.needsConversion(this.tableSource.getProducedDataType());
    }

    protected int[] computeIndexMapping(boolean isStreaming) {
        TableSchema tableSchema = FlinkTypeFactory.toTableSchema(FlinkTypeFactory.INSTANCE().buildRelNodeRowType((RowType)this.getOutputType()));
        return TypeMappingUtils.computePhysicalIndicesOrTimeAttributeMarkers(this.tableSource, (List)tableSchema.getTableColumns(), (boolean)isStreaming, this.getNameRemapping());
    }

    private Function<String, String> getNameRemapping() {
        Map mapping;
        if (this.tableSource instanceof DefinedFieldMapping && (mapping = ((DefinedFieldMapping)this.tableSource).getFieldMapping()) != null) {
            return mapping::get;
        }
        return Function.identity();
    }
}

