/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.extraction;

import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.TypeStrategies;
import org.apache.flink.table.types.inference.TypeStrategy;

@Internal
final class FunctionResultTemplate {
    final DataType dataType;

    private FunctionResultTemplate(DataType dataType) {
        this.dataType = dataType;
    }

    static FunctionResultTemplate of(DataType dataType) {
        return new FunctionResultTemplate(dataType);
    }

    TypeStrategy toTypeStrategy() {
        return TypeStrategies.explicit(this.dataType);
    }

    Class<?> toClass() {
        return this.dataType.getConversionClass();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionResultTemplate that = (FunctionResultTemplate)o;
        return this.dataType.equals(that.dataType);
    }

    public int hashCode() {
        return Objects.hash(this.dataType);
    }
}

