/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.logical;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;

@PublicEvolving
public final class BinaryType
extends LogicalType {
    private static final long serialVersionUID = 1L;
    public static final int EMPTY_LITERAL_LENGTH = 0;
    public static final int MIN_LENGTH = 1;
    public static final int MAX_LENGTH = Integer.MAX_VALUE;
    public static final int DEFAULT_LENGTH = 1;
    private static final String FORMAT = "BINARY(%d)";
    private static final Class<?> INPUT_OUTPUT_CONVERSION = byte[].class;
    private static final Class<?> DEFAULT_CONVERSION = byte[].class;
    private final int length;

    public BinaryType(boolean isNullable, int length) {
        super(isNullable, LogicalTypeRoot.BINARY);
        if (length < 1) {
            throw new ValidationException(String.format("Binary string length must be between %d and %d (both inclusive).", 1, Integer.MAX_VALUE));
        }
        this.length = length;
    }

    public BinaryType(int length) {
        this(true, length);
    }

    public BinaryType() {
        this(1);
    }

    private BinaryType(int length, boolean isNullable) {
        super(isNullable, LogicalTypeRoot.BINARY);
        this.length = length;
    }

    public static BinaryType ofEmptyLiteral() {
        return new BinaryType(0, false);
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public LogicalType copy(boolean isNullable) {
        return new BinaryType(this.length, isNullable);
    }

    @Override
    public String asSerializableString() {
        if (this.length == 0) {
            throw new TableException("Zero-length binary strings have no serializable string representation.");
        }
        return this.withNullability(FORMAT, this.length);
    }

    @Override
    public String asSummaryString() {
        return this.withNullability(FORMAT, this.length);
    }

    @Override
    public boolean supportsInputConversion(Class<?> clazz) {
        return INPUT_OUTPUT_CONVERSION == clazz;
    }

    @Override
    public boolean supportsOutputConversion(Class<?> clazz) {
        return INPUT_OUTPUT_CONVERSION == clazz;
    }

    @Override
    public Class<?> getDefaultConversion() {
        return DEFAULT_CONVERSION;
    }

    @Override
    public List<LogicalType> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R> R accept(LogicalTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BinaryType that = (BinaryType)o;
        return this.length == that.length;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.length);
    }
}

