/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema.property;

import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.configuration.ObjectMapperConfigured;
import springfox.documentation.schema.property.BeanPropertyDefinitions;
import springfox.documentation.schema.property.BeanPropertyNamingStrategy;

@Component
public class ObjectMapperBeanPropertyNamingStrategy
implements BeanPropertyNamingStrategy,
ApplicationListener<ObjectMapperConfigured> {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectMapperBeanPropertyNamingStrategy.class);
    private ObjectMapper objectMapper;

    @Override
    public String nameForSerialization(BeanPropertyDefinition beanProperty) {
        SerializationConfig serializationConfig = this.objectMapper.getSerializationConfig();
        Optional<PropertyNamingStrategy> namingStrategy = Optional.ofNullable(serializationConfig.getPropertyNamingStrategy());
        String newName = namingStrategy.map(BeanPropertyDefinitions.overTheWireName(beanProperty, serializationConfig)).orElse(beanProperty.getName());
        LOG.debug("Name '{}' renamed to '{}'", (Object)beanProperty.getName(), (Object)newName);
        return newName;
    }

    @Override
    public String nameForDeserialization(BeanPropertyDefinition beanProperty) {
        DeserializationConfig deserializationConfig = this.objectMapper.getDeserializationConfig();
        Optional<PropertyNamingStrategy> namingStrategy = Optional.ofNullable(deserializationConfig.getPropertyNamingStrategy());
        String newName = namingStrategy.map(BeanPropertyDefinitions.overTheWireName(beanProperty, deserializationConfig)).orElse(beanProperty.getName());
        LOG.debug("Name '{}' renamed to '{}'", (Object)beanProperty.getName(), (Object)newName);
        return newName;
    }

    public void onApplicationEvent(ObjectMapperConfigured event) {
        this.objectMapper = event.getObjectMapper();
    }
}

