/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.inner.client;

import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.inlong.manager.client.api.ClientConfiguration;
import org.apache.inlong.manager.client.api.service.StreamSourceApi;
import org.apache.inlong.manager.client.api.util.ClientUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.common.BatchResult;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.pojo.source.SourcePageRequest;
import org.apache.inlong.manager.pojo.source.SourceRequest;
import org.apache.inlong.manager.pojo.source.StreamSource;

public class StreamSourceClient {
    private final StreamSourceApi streamSourceApi;

    public StreamSourceClient(ClientConfiguration configuration) {
        this.streamSourceApi = (StreamSourceApi)ClientUtils.createRetrofit(configuration).create(StreamSourceApi.class);
    }

    public Integer createSource(SourceRequest request) {
        Response<Integer> response = ClientUtils.executeHttpCall(this.streamSourceApi.createSource(request));
        ClientUtils.assertRespSuccess(response);
        return (Integer)response.getData();
    }

    public List<BatchResult> batchCreateSource(List<SourceRequest> requestList) {
        Response<List<BatchResult>> response = ClientUtils.executeHttpCall(this.streamSourceApi.batchCreateSource(requestList));
        ClientUtils.assertRespSuccess(response);
        return (List)response.getData();
    }

    public List<StreamSource> listSources(String groupId, String streamId) {
        return this.listSources(groupId, streamId, null);
    }

    public List<StreamSource> listSources(String groupId, String streamId, String sourceType) {
        SourcePageRequest pageRequest = new SourcePageRequest();
        pageRequest.setInlongGroupId(groupId);
        pageRequest.setInlongStreamId(streamId);
        pageRequest.setSourceType(sourceType);
        Response<PageResult<StreamSource>> response = ClientUtils.executeHttpCall(this.streamSourceApi.listSources(pageRequest));
        ClientUtils.assertRespSuccess(response);
        return ((PageResult)response.getData()).getList();
    }

    public List<StreamSource> listSources(SourcePageRequest pageRequest) {
        Response<PageResult<StreamSource>> response = ClientUtils.executeHttpCall(this.streamSourceApi.listSources(pageRequest));
        ClientUtils.assertRespSuccess(response);
        return ((PageResult)response.getData()).getList();
    }

    public Pair<Boolean, String> updateSource(SourceRequest request) {
        Response<Boolean> response = ClientUtils.executeHttpCall(this.streamSourceApi.updateSource(request));
        if (response.getData() != null) {
            return Pair.of((Object)response.getData(), (Object)response.getErrMsg());
        }
        return Pair.of((Object)false, (Object)response.getErrMsg());
    }

    public boolean deleteSource(int id) {
        Preconditions.expectTrue((id > 0 ? 1 : 0) != 0, (String)String.format("sourceId is excepted bigger than 0 but got %d", id));
        Response<Boolean> response = ClientUtils.executeHttpCall(this.streamSourceApi.deleteSource(id));
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }

    public boolean stopSource(int id) {
        Preconditions.expectTrue((id > 0 ? 1 : 0) != 0, (String)String.format("sourceId is excepted bigger than 0 but got %d", id));
        Response<Boolean> response = ClientUtils.executeHttpCall(this.streamSourceApi.stopSource(id));
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }

    public boolean restartSource(int id) {
        Preconditions.expectTrue((id > 0 ? 1 : 0) != 0, (String)"sourceId is illegal");
        Response<Boolean> response = ClientUtils.executeHttpCall(this.streamSourceApi.restartSource(id));
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }

    public boolean forceDelete(String groupId, String streamId) {
        Preconditions.expectNotBlank((String)groupId, (ErrorCodeEnum)ErrorCodeEnum.GROUP_ID_IS_EMPTY);
        Preconditions.expectNotBlank((String)streamId, (ErrorCodeEnum)ErrorCodeEnum.STREAM_ID_IS_EMPTY);
        Response<Boolean> response = ClientUtils.executeHttpCall(this.streamSourceApi.forceDelete(groupId, streamId));
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }

    public StreamSource get(int id) {
        Preconditions.expectTrue((id > 0 ? 1 : 0) != 0, (String)"sourceId is illegal");
        Response<StreamSource> response = ClientUtils.executeHttpCall(this.streamSourceApi.get(id));
        ClientUtils.assertRespSuccess(response);
        return (StreamSource)response.getData();
    }
}

