/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.utils;

import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.apache.inlong.common.util.BasicAuth;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpUtils.class);
    private static final String PARAM_COMPONENT = "component";
    private static HttpClient httpClient = null;

    public static Map<String, String> getAuthHeader(String secretId, String secretKey) {
        HashMap<String, String> header = new HashMap<String, String>();
        try {
            header.put("authorization", BasicAuth.genBasicAuthCredential(secretId, secretKey));
        }
        catch (Exception e) {
            LOGGER.error("Get auth header error", (Throwable)e);
        }
        return header;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String httpGet(String component, String url, String secretId, String secretKey, int timeoutMs) {
        if (httpClient == null) {
            LOGGER.error("httpClient is null");
            return null;
        }
        try {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeoutMs).setConnectionRequestTimeout(timeoutMs).setSocketTimeout(timeoutMs).build();
            URIBuilder uriBuilder = new URIBuilder(url);
            uriBuilder.addParameter(PARAM_COMPONENT, component);
            String finalUrl = uriBuilder.build().toString();
            HttpGet request = new HttpGet(finalUrl);
            request.setConfig(requestConfig);
            Map<String, String> authHeaders = HttpUtils.getAuthHeader(secretId, secretKey);
            for (Map.Entry<String, String> entry : authHeaders.entrySet()) {
                request.addHeader(entry.getKey(), entry.getValue());
            }
            try (CloseableHttpResponse response = (CloseableHttpResponse)httpClient.execute((HttpUriRequest)request);){
                String responseStr = EntityUtils.toString((HttpEntity)response.getEntity());
                LOGGER.info("Http response: {}", (Object)responseStr);
                if (responseStr == null) return null;
                if (responseStr.isEmpty()) return null;
                if (response.getStatusLine().getStatusCode() != 200) return null;
                String string = responseStr;
                return string;
            }
        }
        catch (Throwable e) {
            LOGGER.error("Http request url = {}, secretId = {}, secretKey = {}, component = {} has exception!", new Object[]{url, secretId, secretKey, component, e});
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String httpGet(String url, Map<String, String> queryParams, int timeoutMs) {
        if (httpClient == null) {
            LOGGER.error("httpClient is null");
            return null;
        }
        try {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeoutMs).setConnectionRequestTimeout(timeoutMs).setSocketTimeout(timeoutMs).build();
            URIBuilder uriBuilder = new URIBuilder(url);
            if (queryParams != null) {
                for (Map.Entry<String, String> entry : queryParams.entrySet()) {
                    uriBuilder.addParameter(entry.getKey(), entry.getValue());
                }
            }
            String finalUrl = uriBuilder.build().toString();
            LOGGER.info("Http URL: {}", (Object)finalUrl);
            HttpGet request = new HttpGet(finalUrl);
            request.setConfig(requestConfig);
            try (CloseableHttpResponse response = (CloseableHttpResponse)httpClient.execute((HttpUriRequest)request);){
                String responseStr = EntityUtils.toString((HttpEntity)response.getEntity());
                LOGGER.info("Http response: {}", (Object)responseStr);
                if (responseStr == null) return null;
                if (responseStr.isEmpty()) return null;
                if (response.getStatusLine().getStatusCode() != 200) return null;
                String string = responseStr;
                return string;
            }
        }
        catch (Throwable e) {
            LOGGER.error("Http request url = {} has exception!", (Object)url, (Object)e);
        }
        return null;
    }

    static {
        try {
            SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy()).build();
            httpClient = HttpClientBuilder.create().setSSLContext(sslContext).build();
        }
        catch (Exception e) {
            LOGGER.error("Error initializing SSL context or HTTP client", (Throwable)e);
        }
    }
}

