/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.file;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.flume.channel.file.BadCheckpointException;
import org.apache.flume.channel.file.EventQueueBackingStore;
import org.apache.flume.channel.file.EventQueueBackingStoreFileV2;
import org.apache.flume.channel.file.EventQueueBackingStoreFileV3;
import org.apache.flume.channel.file.Serialization;
import org.apache.flume.channel.file.instrumentation.FileChannelCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventQueueBackingStoreFactory {
    private static final Logger LOG = LoggerFactory.getLogger(EventQueueBackingStoreFactory.class);

    private EventQueueBackingStoreFactory() {
    }

    static EventQueueBackingStore get(File checkpointFile, int capacity, String name, FileChannelCounter counter) throws Exception {
        return EventQueueBackingStoreFactory.get(checkpointFile, capacity, name, counter, true);
    }

    static EventQueueBackingStore get(File checkpointFile, int capacity, String name, FileChannelCounter counter, boolean upgrade) throws Exception {
        return EventQueueBackingStoreFactory.get(checkpointFile, null, capacity, name, counter, upgrade, false, false);
    }

    static EventQueueBackingStore get(File checkpointFile, File backupCheckpointDir, int capacity, String name, FileChannelCounter counter, boolean upgrade, boolean shouldBackup, boolean compressBackup) throws Exception {
        File metaDataFile = Serialization.getMetaDataFile(checkpointFile);
        RandomAccessFile checkpointFileHandle = null;
        try {
            boolean checkpointExists = checkpointFile.exists();
            boolean metaDataExists = metaDataFile.exists();
            if (metaDataExists && (!checkpointExists || checkpointFile.length() == 0L)) {
                LOG.warn("MetaData file for checkpoint  exists but checkpoint does not. Checkpoint = " + checkpointFile + ", metaDataFile = " + metaDataFile);
                throw new BadCheckpointException("The last checkpoint was not completed correctly, since Checkpoint file does not exist while metadata file does.");
            }
            if (!checkpointExists) {
                if (!checkpointFile.createNewFile()) {
                    throw new IOException("Cannot create " + checkpointFile);
                }
                EventQueueBackingStoreFileV3 eventQueueBackingStoreFileV3 = new EventQueueBackingStoreFileV3(checkpointFile, capacity, name, counter, backupCheckpointDir, shouldBackup, compressBackup);
                return eventQueueBackingStoreFileV3;
            }
            if (metaDataExists) {
                EventQueueBackingStoreFileV3 eventQueueBackingStoreFileV3 = new EventQueueBackingStoreFileV3(checkpointFile, capacity, name, counter, backupCheckpointDir, shouldBackup, compressBackup);
                return eventQueueBackingStoreFileV3;
            }
            checkpointFileHandle = new RandomAccessFile(checkpointFile, "r");
            int version = (int)checkpointFileHandle.readLong();
            if (2 == version) {
                if (upgrade) {
                    EventQueueBackingStore eventQueueBackingStore = EventQueueBackingStoreFactory.upgrade(checkpointFile, capacity, name, backupCheckpointDir, shouldBackup, compressBackup, counter);
                    return eventQueueBackingStore;
                }
                EventQueueBackingStoreFileV2 eventQueueBackingStoreFileV2 = new EventQueueBackingStoreFileV2(checkpointFile, capacity, name, counter);
                return eventQueueBackingStoreFileV2;
            }
            LOG.error("Found version " + Integer.toHexString(version) + " in " + checkpointFile);
            throw new BadCheckpointException("Checkpoint file exists with 3 but no metadata file found.");
        }
        finally {
            if (checkpointFileHandle != null) {
                try {
                    checkpointFileHandle.close();
                }
                catch (IOException e) {
                    LOG.warn("Unable to close " + checkpointFile, (Throwable)e);
                }
            }
        }
    }

    private static EventQueueBackingStore upgrade(File checkpointFile, int capacity, String name, File backupCheckpointDir, boolean shouldBackup, boolean compressBackup, FileChannelCounter counter) throws Exception {
        LOG.info("Attempting upgrade of " + checkpointFile + " for " + name);
        EventQueueBackingStoreFileV2 backingStoreV2 = new EventQueueBackingStoreFileV2(checkpointFile, capacity, name, counter);
        String backupName = checkpointFile.getName() + "-backup-" + System.currentTimeMillis();
        Files.copy((File)checkpointFile, (File)new File(checkpointFile.getParentFile(), backupName));
        File metaDataFile = Serialization.getMetaDataFile(checkpointFile);
        EventQueueBackingStoreFileV3.upgrade(backingStoreV2, checkpointFile, metaDataFile);
        return new EventQueueBackingStoreFileV3(checkpointFile, capacity, name, counter, backupCheckpointDir, shouldBackup, compressBackup);
    }
}

