/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.InitializableCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.functional.Mutation;
import org.infinispan.commands.functional.ReadOnlyKeyCommand;
import org.infinispan.commands.functional.ReadOnlyManyCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.TxReadOnlyKeyCommand;
import org.infinispan.commands.functional.TxReadOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.irac.IracCleanupKeyCommand;
import org.infinispan.commands.irac.IracClearKeysCommand;
import org.infinispan.commands.irac.IracMetadataRequestCommand;
import org.infinispan.commands.irac.IracPutKeyCommand;
import org.infinispan.commands.irac.IracRemoveKeyCommand;
import org.infinispan.commands.irac.IracRequestStateCommand;
import org.infinispan.commands.irac.IracStateResponseCommand;
import org.infinispan.commands.irac.IracTouchKeyCommand;
import org.infinispan.commands.irac.IracUpdateVersionCommand;
import org.infinispan.commands.read.EntrySetCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.KeySetCommand;
import org.infinispan.commands.read.SizeCommand;
import org.infinispan.commands.remote.CheckTransactionRpcCommand;
import org.infinispan.commands.remote.ClusteredGetAllCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.GetKeysInGroupCommand;
import org.infinispan.commands.remote.RenewBiasCommand;
import org.infinispan.commands.remote.RevokeBiasCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.remote.recovery.CompleteTransactionCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTransactionsCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTxInfoCommand;
import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commands.statetransfer.ConflictResolutionStartCommand;
import org.infinispan.commands.statetransfer.ScatteredStateConfirmRevokedCommand;
import org.infinispan.commands.statetransfer.ScatteredStateGetKeysCommand;
import org.infinispan.commands.statetransfer.StateResponseCommand;
import org.infinispan.commands.statetransfer.StateTransferCancelCommand;
import org.infinispan.commands.statetransfer.StateTransferGetListenersCommand;
import org.infinispan.commands.statetransfer.StateTransferGetTransactionsCommand;
import org.infinispan.commands.statetransfer.StateTransferStartCommand;
import org.infinispan.commands.triangle.BackupNoopCommand;
import org.infinispan.commands.triangle.MultiEntriesFunctionalBackupWriteCommand;
import org.infinispan.commands.triangle.MultiKeyFunctionalBackupWriteCommand;
import org.infinispan.commands.triangle.PutMapBackupWriteCommand;
import org.infinispan.commands.triangle.SingleKeyBackupWriteCommand;
import org.infinispan.commands.triangle.SingleKeyFunctionalBackupWriteCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.tx.VersionedCommitCommand;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.commands.write.BackupAckCommand;
import org.infinispan.commands.write.BackupMultiKeyAckCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.ExceptionAckCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.InvalidateVersionsCommand;
import org.infinispan.commands.write.IracPutKeyValueCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.RemoveExpiredCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.LambdaExternalizer;
import org.infinispan.commons.marshall.SerializeFunctionWith;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.commons.util.IntSet;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.XSiteStateTransferMode;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.versioning.irac.IracEntryVersion;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.encoding.DataConversion;
import org.infinispan.expiration.impl.TouchCommand;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.impl.Params;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.GlobalMarshaller;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.notifications.cachelistener.cluster.ClusterEvent;
import org.infinispan.notifications.cachelistener.cluster.MultiClusterEventCommand;
import org.infinispan.reactive.publisher.impl.DeliveryGuarantee;
import org.infinispan.reactive.publisher.impl.commands.batch.CancelPublisherCommand;
import org.infinispan.reactive.publisher.impl.commands.batch.InitialPublisherCommand;
import org.infinispan.reactive.publisher.impl.commands.batch.NextPublisherCommand;
import org.infinispan.reactive.publisher.impl.commands.reduction.ReductionPublisherRequestCommand;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.StateChunk;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.SingleXSiteRpcCommand;
import org.infinispan.xsite.commands.XSiteAmendOfflineStatusCommand;
import org.infinispan.xsite.commands.XSiteAutoTransferStatusCommand;
import org.infinispan.xsite.commands.XSiteBringOnlineCommand;
import org.infinispan.xsite.commands.XSiteOfflineStatusCommand;
import org.infinispan.xsite.commands.XSiteSetStateTransferModeCommand;
import org.infinispan.xsite.commands.XSiteStateTransferCancelSendCommand;
import org.infinispan.xsite.commands.XSiteStateTransferClearStatusCommand;
import org.infinispan.xsite.commands.XSiteStateTransferFinishReceiveCommand;
import org.infinispan.xsite.commands.XSiteStateTransferFinishSendCommand;
import org.infinispan.xsite.commands.XSiteStateTransferRestartSendingCommand;
import org.infinispan.xsite.commands.XSiteStateTransferStartReceiveCommand;
import org.infinispan.xsite.commands.XSiteStateTransferStartSendCommand;
import org.infinispan.xsite.commands.XSiteStateTransferStatusRequestCommand;
import org.infinispan.xsite.commands.XSiteStatusCommand;
import org.infinispan.xsite.commands.XSiteTakeOfflineCommand;
import org.infinispan.xsite.statetransfer.XSiteState;
import org.infinispan.xsite.statetransfer.XSiteStatePushCommand;
import org.reactivestreams.Publisher;

@Scope(value=Scopes.NAMED_CACHE)
public class CommandsFactoryImpl
implements CommandsFactory {
    private static final Log log = LogFactory.getLog(CommandsFactoryImpl.class);
    @Inject
    ClusteringDependentLogic clusteringDependentLogic;
    @Inject
    Configuration configuration;
    @Inject
    ComponentRef<Cache<Object, Object>> cache;
    @Inject
    ComponentRegistry componentRegistry;
    @Inject
    EmbeddedCacheManager cacheManager;
    @Inject
    @ComponentName(value="org.infinispan.marshaller.internal")
    StreamingMarshaller marshaller;
    private ByteString cacheName;
    private boolean transactional;

    @Start(priority=1)
    public void start() {
        this.cacheName = ByteString.fromString(this.cache.wired().getName());
        this.transactional = this.configuration.transaction().transactionMode().isTransactional();
    }

    @Override
    public PutKeyValueCommand buildPutKeyValueCommand(Object key, Object value, int segment, Metadata metadata, long flagsBitSet) {
        boolean reallyTransactional = this.transactional && !EnumUtil.containsAny((long)flagsBitSet, (long)FlagBitSets.PUT_FOR_EXTERNAL_READ);
        return new PutKeyValueCommand(key, value, false, metadata, segment, flagsBitSet, this.generateUUID(reallyTransactional));
    }

    @Override
    public RemoveCommand buildRemoveCommand(Object key, Object value, int segment, long flagsBitSet) {
        return new RemoveCommand(key, value, segment, flagsBitSet, this.generateUUID(this.transactional));
    }

    @Override
    public InvalidateCommand buildInvalidateCommand(long flagsBitSet, Object ... keys) {
        return new InvalidateCommand(flagsBitSet, this.generateUUID(false), keys);
    }

    @Override
    public InvalidateCommand buildInvalidateFromL1Command(long flagsBitSet, Collection<Object> keys) {
        return new InvalidateL1Command(flagsBitSet, keys, this.generateUUID(this.transactional));
    }

    @Override
    public InvalidateCommand buildInvalidateFromL1Command(Address origin, long flagsBitSet, Collection<Object> keys) {
        return new InvalidateL1Command(origin, flagsBitSet, keys, this.generateUUID(false));
    }

    @Override
    public RemoveExpiredCommand buildRemoveExpiredCommand(Object key, Object value, int segment, Long lifespan, long flagsBitSet) {
        return new RemoveExpiredCommand(key, value, lifespan, false, segment, flagsBitSet, this.generateUUID(this.transactional));
    }

    @Override
    public RemoveExpiredCommand buildRemoveExpiredCommand(Object key, Object value, int segment, long flagsBitSet) {
        return new RemoveExpiredCommand(key, value, null, true, segment, flagsBitSet, this.generateUUID(this.transactional));
    }

    @Override
    public ReplaceCommand buildReplaceCommand(Object key, Object oldValue, Object newValue, int segment, Metadata metadata, long flagsBitSet) {
        return new ReplaceCommand(key, oldValue, newValue, metadata, segment, flagsBitSet, this.generateUUID(this.transactional));
    }

    @Override
    public ComputeCommand buildComputeCommand(Object key, BiFunction mappingFunction, boolean computeIfPresent, int segment, Metadata metadata, long flagsBitSet) {
        return (ComputeCommand)this.init(new ComputeCommand(key, mappingFunction, computeIfPresent, segment, flagsBitSet, this.generateUUID(this.transactional), metadata));
    }

    @Override
    public ComputeIfAbsentCommand buildComputeIfAbsentCommand(Object key, Function mappingFunction, int segment, Metadata metadata, long flagsBitSet) {
        return (ComputeIfAbsentCommand)this.init(new ComputeIfAbsentCommand(key, mappingFunction, segment, flagsBitSet, this.generateUUID(this.transactional), metadata));
    }

    @Override
    public SizeCommand buildSizeCommand(long flagsBitSet) {
        return new SizeCommand(flagsBitSet);
    }

    @Override
    public KeySetCommand buildKeySetCommand(long flagsBitSet) {
        return new KeySetCommand(flagsBitSet);
    }

    @Override
    public EntrySetCommand buildEntrySetCommand(long flagsBitSet) {
        return new EntrySetCommand(flagsBitSet);
    }

    @Override
    public GetKeyValueCommand buildGetKeyValueCommand(Object key, int segment, long flagsBitSet) {
        return new GetKeyValueCommand(key, segment, flagsBitSet);
    }

    @Override
    public GetAllCommand buildGetAllCommand(Collection<?> keys, long flagsBitSet, boolean returnEntries) {
        return new GetAllCommand(keys, flagsBitSet, returnEntries);
    }

    @Override
    public PutMapCommand buildPutMapCommand(Map<?, ?> map, Metadata metadata, long flagsBitSet) {
        return new PutMapCommand(map, metadata, flagsBitSet, this.generateUUID(this.transactional));
    }

    @Override
    public ClearCommand buildClearCommand(long flagsBitSet) {
        return new ClearCommand(flagsBitSet);
    }

    @Override
    public EvictCommand buildEvictCommand(Object key, int segment, long flagsBitSet) {
        return new EvictCommand(key, segment, flagsBitSet, this.generateUUID(this.transactional));
    }

    @Override
    public PrepareCommand buildPrepareCommand(GlobalTransaction gtx, List<WriteCommand> modifications, boolean onePhaseCommit) {
        return new PrepareCommand(this.cacheName, gtx, modifications, onePhaseCommit);
    }

    @Override
    public VersionedPrepareCommand buildVersionedPrepareCommand(GlobalTransaction gtx, List<WriteCommand> modifications, boolean onePhase) {
        return new VersionedPrepareCommand(this.cacheName, gtx, modifications, onePhase);
    }

    @Override
    public CommitCommand buildCommitCommand(GlobalTransaction gtx) {
        return new CommitCommand(this.cacheName, gtx);
    }

    @Override
    public VersionedCommitCommand buildVersionedCommitCommand(GlobalTransaction gtx) {
        return new VersionedCommitCommand(this.cacheName, gtx);
    }

    @Override
    public RollbackCommand buildRollbackCommand(GlobalTransaction gtx) {
        return new RollbackCommand(this.cacheName, gtx);
    }

    @Override
    public SingleRpcCommand buildSingleRpcCommand(VisitableCommand call) {
        return new SingleRpcCommand(this.cacheName, call);
    }

    @Override
    public ClusteredGetCommand buildClusteredGetCommand(Object key, Integer segment, long flagsBitSet) {
        return new ClusteredGetCommand(key, this.cacheName, segment, flagsBitSet);
    }

    @Override
    public void initializeReplicableCommand(ReplicableCommand c, boolean isRemote) {
        if (c == null) {
            return;
        }
        if (c instanceof InitializableCommand) {
            ((InitializableCommand)((Object)c)).init(this.componentRegistry, isRemote);
        }
    }

    private <T> T init(VisitableCommand cmd) {
        cmd.init(this.componentRegistry);
        return (T)cmd;
    }

    @Override
    public LockControlCommand buildLockControlCommand(Collection<?> keys, long flagsBitSet, GlobalTransaction gtx) {
        return new LockControlCommand(keys, this.cacheName, flagsBitSet, gtx);
    }

    @Override
    public LockControlCommand buildLockControlCommand(Object key, long flagsBitSet, GlobalTransaction gtx) {
        return new LockControlCommand(key, this.cacheName, flagsBitSet, gtx);
    }

    @Override
    public LockControlCommand buildLockControlCommand(Collection<?> keys, long flagsBitSet) {
        return new LockControlCommand(keys, this.cacheName, flagsBitSet, null);
    }

    @Override
    public ConflictResolutionStartCommand buildConflictResolutionStartCommand(int topologyId, IntSet segments) {
        return new ConflictResolutionStartCommand(this.cacheName, topologyId, segments);
    }

    @Override
    public ScatteredStateConfirmRevokedCommand buildScatteredStateConfirmRevokeCommand(int topologyId, IntSet segments) {
        return new ScatteredStateConfirmRevokedCommand(this.cacheName, topologyId, segments);
    }

    @Override
    public ScatteredStateGetKeysCommand buildScatteredStateGetKeysCommand(int topologyId, IntSet segments) {
        return new ScatteredStateGetKeysCommand(this.cacheName, topologyId, segments);
    }

    @Override
    public StateTransferCancelCommand buildStateTransferCancelCommand(int topologyId, IntSet segments) {
        return new StateTransferCancelCommand(this.cacheName, topologyId, segments);
    }

    @Override
    public StateTransferGetListenersCommand buildStateTransferGetListenersCommand(int topologyId) {
        return new StateTransferGetListenersCommand(this.cacheName, topologyId);
    }

    @Override
    public StateTransferGetTransactionsCommand buildStateTransferGetTransactionsCommand(int topologyId, IntSet segments) {
        return new StateTransferGetTransactionsCommand(this.cacheName, topologyId, segments);
    }

    @Override
    public StateTransferStartCommand buildStateTransferStartCommand(int topologyId, IntSet segments) {
        return new StateTransferStartCommand(this.cacheName, topologyId, segments);
    }

    @Override
    public StateResponseCommand buildStateResponseCommand(int topologyId, Collection<StateChunk> stateChunks, boolean applyState, boolean pushTransfer) {
        return new StateResponseCommand(this.cacheName, topologyId, stateChunks, applyState, pushTransfer);
    }

    @Override
    public String getCacheName() {
        return this.cacheName.toString();
    }

    @Override
    public GetInDoubtTransactionsCommand buildGetInDoubtTransactionsCommand() {
        return new GetInDoubtTransactionsCommand(this.cacheName);
    }

    @Override
    public TxCompletionNotificationCommand buildTxCompletionNotificationCommand(XidImpl xid, GlobalTransaction globalTransaction) {
        return new TxCompletionNotificationCommand(xid, globalTransaction, this.cacheName);
    }

    @Override
    public TxCompletionNotificationCommand buildTxCompletionNotificationCommand(long internalId) {
        return new TxCompletionNotificationCommand(internalId, this.cacheName);
    }

    @Override
    public GetInDoubtTxInfoCommand buildGetInDoubtTxInfoCommand() {
        return new GetInDoubtTxInfoCommand(this.cacheName);
    }

    @Override
    public CompleteTransactionCommand buildCompleteTransactionCommand(XidImpl xid, boolean commit) {
        return new CompleteTransactionCommand(this.cacheName, xid, commit);
    }

    @Override
    public XSiteStateTransferCancelSendCommand buildXSiteStateTransferCancelSendCommand(String siteName) {
        return new XSiteStateTransferCancelSendCommand(this.cacheName, siteName);
    }

    @Override
    public XSiteStateTransferClearStatusCommand buildXSiteStateTransferClearStatusCommand() {
        return new XSiteStateTransferClearStatusCommand(this.cacheName);
    }

    @Override
    public XSiteStateTransferFinishReceiveCommand buildXSiteStateTransferFinishReceiveCommand(String siteName) {
        return new XSiteStateTransferFinishReceiveCommand(this.cacheName, siteName);
    }

    @Override
    public XSiteStateTransferFinishSendCommand buildXSiteStateTransferFinishSendCommand(String siteName, boolean statusOk) {
        return new XSiteStateTransferFinishSendCommand(this.cacheName, siteName, statusOk);
    }

    @Override
    public XSiteStateTransferRestartSendingCommand buildXSiteStateTransferRestartSendingCommand(String siteName, int topologyId) {
        return new XSiteStateTransferRestartSendingCommand(this.cacheName, siteName, topologyId);
    }

    @Override
    public XSiteStateTransferStartReceiveCommand buildXSiteStateTransferStartReceiveCommand() {
        return new XSiteStateTransferStartReceiveCommand(this.cacheName);
    }

    @Override
    public XSiteStateTransferStartSendCommand buildXSiteStateTransferStartSendCommand(String siteName, int topologyId) {
        return new XSiteStateTransferStartSendCommand(this.cacheName, siteName, topologyId);
    }

    @Override
    public XSiteStateTransferStatusRequestCommand buildXSiteStateTransferStatusRequestCommand() {
        return new XSiteStateTransferStatusRequestCommand(this.cacheName);
    }

    @Override
    public XSiteAmendOfflineStatusCommand buildXSiteAmendOfflineStatusCommand(String siteName, Integer afterFailures, Long minTimeToWait) {
        return new XSiteAmendOfflineStatusCommand(this.cacheName, siteName, afterFailures, minTimeToWait);
    }

    @Override
    public XSiteBringOnlineCommand buildXSiteBringOnlineCommand(String siteName) {
        return new XSiteBringOnlineCommand(this.cacheName, siteName);
    }

    @Override
    public XSiteOfflineStatusCommand buildXSiteOfflineStatusCommand(String siteName) {
        return new XSiteOfflineStatusCommand(this.cacheName, siteName);
    }

    @Override
    public XSiteStatusCommand buildXSiteStatusCommand() {
        return new XSiteStatusCommand(this.cacheName);
    }

    @Override
    public XSiteTakeOfflineCommand buildXSiteTakeOfflineCommand(String siteName) {
        return new XSiteTakeOfflineCommand(this.cacheName, siteName);
    }

    @Override
    public XSiteStatePushCommand buildXSiteStatePushCommand(XSiteState[] chunk, long timeoutMillis) {
        return new XSiteStatePushCommand(this.cacheName, chunk, timeoutMillis);
    }

    @Override
    public SingleXSiteRpcCommand buildSingleXSiteRpcCommand(VisitableCommand command) {
        return new SingleXSiteRpcCommand(this.cacheName, command);
    }

    @Override
    public GetKeysInGroupCommand buildGetKeysInGroupCommand(long flagsBitSet, Object groupName) {
        return new GetKeysInGroupCommand(flagsBitSet, groupName);
    }

    @Override
    public GetCacheEntryCommand buildGetCacheEntryCommand(Object key, int segment, long flagsBitSet) {
        return new GetCacheEntryCommand(key, segment, flagsBitSet);
    }

    @Override
    public ClusteredGetAllCommand buildClusteredGetAllCommand(List<?> keys, long flagsBitSet, GlobalTransaction gtx) {
        return new ClusteredGetAllCommand(this.cacheName, keys, flagsBitSet, gtx);
    }

    private CommandInvocationId generateUUID(boolean tx) {
        if (tx) {
            return CommandInvocationId.DUMMY_INVOCATION_ID;
        }
        return CommandInvocationId.generateId(this.clusteringDependentLogic.getAddress());
    }

    @Override
    public <K, V, R> ReadOnlyKeyCommand<K, V, R> buildReadOnlyKeyCommand(Object key, Function<EntryView.ReadEntryView<K, V>, R> f, int segment, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        return (ReadOnlyKeyCommand)this.init(new ReadOnlyKeyCommand<K, V, R>(key, f, segment, params, keyDataConversion, valueDataConversion));
    }

    @Override
    public <K, V, R> ReadOnlyManyCommand<K, V, R> buildReadOnlyManyCommand(Collection<?> keys, Function<EntryView.ReadEntryView<K, V>, R> f, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        return (ReadOnlyManyCommand)this.init(new ReadOnlyManyCommand<K, V, R>(keys, f, params, keyDataConversion, valueDataConversion));
    }

    @Override
    public <K, V, T, R> ReadWriteKeyValueCommand<K, V, T, R> buildReadWriteKeyValueCommand(Object key, Object argument, BiFunction<T, EntryView.ReadWriteEntryView<K, V>, R> f, int segment, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        return (ReadWriteKeyValueCommand)this.init(new ReadWriteKeyValueCommand<K, V, T, R>(key, argument, f, segment, this.generateUUID(this.transactional), this.getValueMatcher(f), params, keyDataConversion, valueDataConversion));
    }

    @Override
    public <K, V, R> ReadWriteKeyCommand<K, V, R> buildReadWriteKeyCommand(Object key, Function<EntryView.ReadWriteEntryView<K, V>, R> f, int segment, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        return (ReadWriteKeyCommand)this.init(new ReadWriteKeyCommand<K, V, R>(key, f, segment, this.generateUUID(this.transactional), this.getValueMatcher(f), params, keyDataConversion, valueDataConversion));
    }

    @Override
    public <K, V, R> ReadWriteManyCommand<K, V, R> buildReadWriteManyCommand(Collection<?> keys, Function<EntryView.ReadWriteEntryView<K, V>, R> f, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        return (ReadWriteManyCommand)this.init(new ReadWriteManyCommand<K, V, R>(keys, f, params, this.generateUUID(this.transactional), keyDataConversion, valueDataConversion));
    }

    @Override
    public <K, V, T, R> ReadWriteManyEntriesCommand<K, V, T, R> buildReadWriteManyEntriesCommand(Map<?, ?> entries, BiFunction<T, EntryView.ReadWriteEntryView<K, V>, R> f, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        return (ReadWriteManyEntriesCommand)this.init(new ReadWriteManyEntriesCommand<K, V, T, R>(entries, f, params, this.generateUUID(this.transactional), keyDataConversion, valueDataConversion));
    }

    @Override
    public InvalidateVersionsCommand buildInvalidateVersionsCommand(int topologyId, Object[] keys, int[] topologyIds, long[] versions, boolean removed) {
        return new InvalidateVersionsCommand(this.cacheName, topologyId, keys, topologyIds, versions, removed);
    }

    @Override
    public <K, V> WriteOnlyKeyCommand<K, V> buildWriteOnlyKeyCommand(Object key, Consumer<EntryView.WriteEntryView<K, V>> f, int segment, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        return (WriteOnlyKeyCommand)this.init(new WriteOnlyKeyCommand<K, V>(key, f, segment, this.generateUUID(this.transactional), this.getValueMatcher(f), params, keyDataConversion, valueDataConversion));
    }

    @Override
    public <K, V, T> WriteOnlyKeyValueCommand<K, V, T> buildWriteOnlyKeyValueCommand(Object key, Object argument, BiConsumer<T, EntryView.WriteEntryView<K, V>> f, int segment, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        return (WriteOnlyKeyValueCommand)this.init(new WriteOnlyKeyValueCommand<K, V, T>(key, argument, f, segment, this.generateUUID(this.transactional), this.getValueMatcher(f), params, keyDataConversion, valueDataConversion));
    }

    @Override
    public <K, V> WriteOnlyManyCommand<K, V> buildWriteOnlyManyCommand(Collection<?> keys, Consumer<EntryView.WriteEntryView<K, V>> f, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        return (WriteOnlyManyCommand)this.init(new WriteOnlyManyCommand<K, V>(keys, f, params, this.generateUUID(this.transactional), keyDataConversion, valueDataConversion));
    }

    @Override
    public <K, V, T> WriteOnlyManyEntriesCommand<K, V, T> buildWriteOnlyManyEntriesCommand(Map<?, ?> arguments, BiConsumer<T, EntryView.WriteEntryView<K, V>> f, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        return (WriteOnlyManyEntriesCommand)this.init(new WriteOnlyManyEntriesCommand<K, V, T>(arguments, f, params, this.generateUUID(this.transactional), keyDataConversion, valueDataConversion));
    }

    @Override
    public <K, V, R> TxReadOnlyKeyCommand<K, V, R> buildTxReadOnlyKeyCommand(Object key, Function<EntryView.ReadEntryView<K, V>, R> f, List<Mutation<K, V, ?>> mutations, int segment, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        return (TxReadOnlyKeyCommand)this.init(new TxReadOnlyKeyCommand<K, V, R>(key, f, mutations, segment, params, keyDataConversion, valueDataConversion));
    }

    @Override
    public <K, V, R> TxReadOnlyManyCommand<K, V, R> buildTxReadOnlyManyCommand(Collection<?> keys, List<List<Mutation<K, V, ?>>> mutations, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        return (TxReadOnlyManyCommand)this.init(new TxReadOnlyManyCommand(keys, mutations, params, keyDataConversion, valueDataConversion));
    }

    @Override
    public BackupAckCommand buildBackupAckCommand(long id, int topologyId) {
        return new BackupAckCommand(this.cacheName, id, topologyId);
    }

    @Override
    public BackupMultiKeyAckCommand buildBackupMultiKeyAckCommand(long id, int segment, int topologyId) {
        return new BackupMultiKeyAckCommand(this.cacheName, id, segment, topologyId);
    }

    @Override
    public ExceptionAckCommand buildExceptionAckCommand(long id, Throwable throwable, int topologyId) {
        return new ExceptionAckCommand(this.cacheName, id, throwable, topologyId);
    }

    private ValueMatcher getValueMatcher(Object o) {
        SerializeFunctionWith ann = o.getClass().getAnnotation(SerializeFunctionWith.class);
        if (ann != null) {
            return ValueMatcher.valueOf(ann.valueMatcher().toString());
        }
        Externalizer ext = ((GlobalMarshaller)this.marshaller).findExternalizerFor(o);
        if (ext instanceof LambdaExternalizer) {
            return ValueMatcher.valueOf(((LambdaExternalizer)ext).valueMatcher(o).toString());
        }
        return ValueMatcher.MATCH_ALWAYS;
    }

    @Override
    public RevokeBiasCommand buildRevokeBiasCommand(Address ackTarget, long id, int topologyId, Collection<Object> keys) {
        return new RevokeBiasCommand(this.cacheName, ackTarget, id, topologyId, keys);
    }

    @Override
    public RenewBiasCommand buildRenewBiasCommand(Object[] keys) {
        return new RenewBiasCommand(this.cacheName, keys);
    }

    @Override
    public SingleKeyBackupWriteCommand buildSingleKeyBackupWriteCommand() {
        return new SingleKeyBackupWriteCommand(this.cacheName);
    }

    @Override
    public SingleKeyFunctionalBackupWriteCommand buildSingleKeyFunctionalBackupWriteCommand() {
        return new SingleKeyFunctionalBackupWriteCommand(this.cacheName);
    }

    @Override
    public PutMapBackupWriteCommand buildPutMapBackupWriteCommand() {
        return new PutMapBackupWriteCommand(this.cacheName);
    }

    @Override
    public MultiEntriesFunctionalBackupWriteCommand buildMultiEntriesFunctionalBackupWriteCommand() {
        return new MultiEntriesFunctionalBackupWriteCommand(this.cacheName);
    }

    @Override
    public MultiKeyFunctionalBackupWriteCommand buildMultiKeyFunctionalBackupWriteCommand() {
        return new MultiKeyFunctionalBackupWriteCommand(this.cacheName);
    }

    @Override
    public BackupNoopCommand buildBackupNoopCommand() {
        return new BackupNoopCommand(this.cacheName);
    }

    @Override
    public <K, R> ReductionPublisherRequestCommand<K> buildKeyReductionPublisherCommand(boolean parallelStream, DeliveryGuarantee deliveryGuarantee, IntSet segments, Set<K> keys, Set<K> excludedKeys, boolean includeLoader, Function<? super Publisher<K>, ? extends CompletionStage<R>> transformer, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer) {
        return new ReductionPublisherRequestCommand<K>(this.cacheName, parallelStream, deliveryGuarantee, segments, keys, excludedKeys, includeLoader, false, transformer, finalizer);
    }

    @Override
    public <K, V, R> ReductionPublisherRequestCommand<K> buildEntryReductionPublisherCommand(boolean parallelStream, DeliveryGuarantee deliveryGuarantee, IntSet segments, Set<K> keys, Set<K> excludedKeys, boolean includeLoader, Function<? super Publisher<CacheEntry<K, V>>, ? extends CompletionStage<R>> transformer, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer) {
        return new ReductionPublisherRequestCommand<K>(this.cacheName, parallelStream, deliveryGuarantee, segments, keys, excludedKeys, includeLoader, true, transformer, finalizer);
    }

    @Override
    public <K, I, R> InitialPublisherCommand<K, I, R> buildInitialPublisherCommand(String requestId, DeliveryGuarantee deliveryGuarantee, int batchSize, IntSet segments, Set<K> keys, Set<K> excludedKeys, boolean includeLoader, boolean entryStream, boolean trackKeys, Function<? super Publisher<I>, ? extends Publisher<R>> transformer) {
        return new InitialPublisherCommand(this.cacheName, requestId, deliveryGuarantee, batchSize, segments, keys, excludedKeys, includeLoader, entryStream, trackKeys, transformer);
    }

    @Override
    public NextPublisherCommand buildNextPublisherCommand(String requestId) {
        return new NextPublisherCommand(this.cacheName, requestId);
    }

    @Override
    public CancelPublisherCommand buildCancelPublisherCommand(String requestId) {
        return new CancelPublisherCommand(this.cacheName, requestId);
    }

    @Override
    public <K, V> MultiClusterEventCommand<K, V> buildMultiClusterEventCommand(Map<UUID, Collection<ClusterEvent<K, V>>> events) {
        return new MultiClusterEventCommand<K, V>(this.cacheName, events);
    }

    @Override
    public CheckTransactionRpcCommand buildCheckTransactionRpcCommand(Collection<GlobalTransaction> globalTransactions) {
        return new CheckTransactionRpcCommand(this.cacheName, globalTransactions);
    }

    @Override
    public TouchCommand buildTouchCommand(Object key, int segment, boolean touchEvenIfExpired, long flagBitSet) {
        return new TouchCommand(key, segment, flagBitSet, touchEvenIfExpired);
    }

    @Override
    public <K, V> IracPutKeyCommand buildIracPutKeyCommand(InternalCacheEntry<K, V> entry) {
        PrivateMetadata internalMetadata = entry.getInternalMetadata();
        assert (internalMetadata != null) : "[IRAC] Metadata to send to remote site is null! key=" + entry.getKey();
        IracMetadata iracMetadata = internalMetadata.iracMetadata();
        return new IracPutKeyCommand(this.cacheName, entry.getKey(), entry.getValue(), entry.getMetadata(), iracMetadata);
    }

    @Override
    public IracRemoveKeyCommand buildIracRemoveKeyCommand(Object key, IracMetadata iracMetadata, boolean expiration) {
        return new IracRemoveKeyCommand(this.cacheName, key, iracMetadata, expiration);
    }

    @Override
    public IracClearKeysCommand buildIracClearKeysCommand() {
        return new IracClearKeysCommand(this.cacheName);
    }

    @Override
    public IracCleanupKeyCommand buildIracCleanupKeyCommand(int segment, Object key, Object lockOwner, IracMetadata tombstone) {
        return new IracCleanupKeyCommand(this.cacheName, segment, key, lockOwner, tombstone);
    }

    @Override
    public IracMetadataRequestCommand buildIracMetadataRequestCommand(int segment, IracEntryVersion versionSeen) {
        return new IracMetadataRequestCommand(this.cacheName, segment, versionSeen);
    }

    @Override
    public IracRequestStateCommand buildIracRequestStateCommand(IntSet segments) {
        return new IracRequestStateCommand(this.cacheName, segments);
    }

    @Override
    public IracStateResponseCommand buildIracStateResponseCommand(int segment, Object key, Object lockOwner, IracMetadata tombstone) {
        return new IracStateResponseCommand(this.cacheName, segment, key, lockOwner, tombstone);
    }

    @Override
    public IracPutKeyValueCommand buildIracPutKeyValueCommand(Object key, int segment, Object value, Metadata metadata, PrivateMetadata privateMetadata) {
        return new IracPutKeyValueCommand(key, segment, this.generateUUID(false), value, metadata, privateMetadata);
    }

    @Override
    public IracTouchKeyCommand buildIracTouchCommand(Object key) {
        return new IracTouchKeyCommand(this.cacheName, key);
    }

    @Override
    public IracUpdateVersionCommand buildIracUpdateVersionCommand(Map<Integer, IracEntryVersion> segmentsVersion) {
        return new IracUpdateVersionCommand(this.cacheName, segmentsVersion);
    }

    @Override
    public XSiteAutoTransferStatusCommand buildXSiteAutoTransferStatusCommand(String site) {
        return new XSiteAutoTransferStatusCommand(this.cacheName, site);
    }

    @Override
    public XSiteSetStateTransferModeCommand buildXSiteSetStateTransferModeCommand(String site, XSiteStateTransferMode mode) {
        return new XSiteSetStateTransferModeCommand(this.cacheName, site, mode);
    }
}

