/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import java.util.ArrayList;
import java.util.List;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.GrantType;
import springfox.documentation.service.OAuth;

public class OAuthBuilder {
    private List<AuthorizationScope> scopes = new ArrayList<AuthorizationScope>();
    private List<GrantType> grantTypes = new ArrayList<GrantType>();
    private String name;

    public OAuthBuilder scopes(List<AuthorizationScope> scopes) {
        this.scopes.addAll(BuilderDefaults.nullToEmptyList(scopes));
        return this;
    }

    public OAuthBuilder grantTypes(List<GrantType> grantTypes) {
        this.grantTypes.addAll(BuilderDefaults.nullToEmptyList(grantTypes));
        return this;
    }

    public OAuthBuilder name(String name) {
        this.name = BuilderDefaults.defaultIfAbsent(name, this.name);
        return this;
    }

    public OAuth build() {
        return new OAuth(this.name, this.scopes, this.grantTypes);
    }
}

