/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;

public class RequestManager {
    private final Map<Integer, ConnectionState> connections = new HashMap<Integer, ConnectionState>();
    private final List<Integer> voters = new ArrayList<Integer>();
    private final int retryBackoffMs;
    private final int requestTimeoutMs;
    private final Random random;

    public RequestManager(Set<Integer> voterIds, int retryBackoffMs, int requestTimeoutMs, Random random) {
        this.retryBackoffMs = retryBackoffMs;
        this.requestTimeoutMs = requestTimeoutMs;
        this.voters.addAll(voterIds);
        this.random = random;
        for (Integer voterId : voterIds) {
            ConnectionState connection = new ConnectionState(voterId.intValue());
            this.connections.put(voterId, connection);
        }
    }

    public ConnectionState getOrCreate(int id) {
        return this.connections.computeIfAbsent(id, key -> new ConnectionState(id));
    }

    public OptionalInt findReadyVoter(long currentTimeMs) {
        int startIndex = this.random.nextInt(this.voters.size());
        OptionalInt res = OptionalInt.empty();
        for (int i = 0; i < this.voters.size(); ++i) {
            int index = (startIndex + i) % this.voters.size();
            Integer voterId = this.voters.get(index);
            ConnectionState connection = this.connections.get(voterId);
            boolean isReady = connection.isReady(currentTimeMs);
            if (isReady) {
                res = OptionalInt.of(voterId);
                continue;
            }
            if (!connection.inFlightCorrelationId.isPresent()) continue;
            res = OptionalInt.empty();
            break;
        }
        return res;
    }

    public long backoffBeforeAvailableVoter(long currentTimeMs) {
        long minBackoffMs = Long.MAX_VALUE;
        for (Integer voterId : this.voters) {
            ConnectionState connection = this.connections.get(voterId);
            if (connection.isReady(currentTimeMs)) {
                return 0L;
            }
            if (connection.isBackingOff(currentTimeMs)) {
                minBackoffMs = Math.min(minBackoffMs, connection.remainingBackoffMs(currentTimeMs));
                continue;
            }
            minBackoffMs = Math.min(minBackoffMs, connection.remainingRequestTimeMs(currentTimeMs));
        }
        return minBackoffMs;
    }

    public void resetAll() {
        for (ConnectionState connectionState : this.connections.values()) {
            connectionState.reset();
        }
    }

    public class ConnectionState {
        private final long id;
        private State state = State.READY;
        private long lastSendTimeMs = 0L;
        private long lastFailTimeMs = 0L;
        private Optional<Long> inFlightCorrelationId = Optional.empty();

        public ConnectionState(long id) {
            this.id = id;
        }

        private boolean isBackoffComplete(long timeMs) {
            return this.state == State.BACKING_OFF && timeMs >= this.lastFailTimeMs + (long)RequestManager.this.retryBackoffMs;
        }

        boolean hasRequestTimedOut(long timeMs) {
            return this.state == State.AWAITING_REQUEST && timeMs >= this.lastSendTimeMs + (long)RequestManager.this.requestTimeoutMs;
        }

        public long id() {
            return this.id;
        }

        boolean isReady(long timeMs) {
            if (this.isBackoffComplete(timeMs) || this.hasRequestTimedOut(timeMs)) {
                this.state = State.READY;
            }
            return this.state == State.READY;
        }

        boolean isBackingOff(long timeMs) {
            if (this.state != State.BACKING_OFF) {
                return false;
            }
            return !this.isBackoffComplete(timeMs);
        }

        boolean hasInflightRequest(long timeMs) {
            if (this.state != State.AWAITING_REQUEST) {
                return false;
            }
            return !this.hasRequestTimedOut(timeMs);
        }

        long remainingRequestTimeMs(long timeMs) {
            if (this.hasInflightRequest(timeMs)) {
                return this.lastSendTimeMs + (long)RequestManager.this.requestTimeoutMs - timeMs;
            }
            return 0L;
        }

        long remainingBackoffMs(long timeMs) {
            if (this.isBackingOff(timeMs)) {
                return this.lastFailTimeMs + (long)RequestManager.this.retryBackoffMs - timeMs;
            }
            return 0L;
        }

        void onResponseError(long correlationId, long timeMs) {
            this.inFlightCorrelationId.ifPresent(inflightRequestId -> {
                if (inflightRequestId == correlationId) {
                    this.lastFailTimeMs = timeMs;
                    this.state = State.BACKING_OFF;
                    this.inFlightCorrelationId = Optional.empty();
                }
            });
        }

        void onResponseReceived(long correlationId, long timeMs) {
            this.inFlightCorrelationId.ifPresent(inflightRequestId -> {
                if (inflightRequestId == correlationId) {
                    this.state = State.READY;
                    this.inFlightCorrelationId = Optional.empty();
                }
            });
        }

        void onRequestSent(long correlationId, long timeMs) {
            this.lastSendTimeMs = timeMs;
            this.inFlightCorrelationId = Optional.of(correlationId);
            this.state = State.AWAITING_REQUEST;
        }

        void reset() {
            this.state = State.READY;
            this.inFlightCorrelationId = Optional.empty();
        }

        public String toString() {
            return "ConnectionState(id=" + this.id + ", state=" + (Object)((Object)this.state) + ", lastSendTimeMs=" + this.lastSendTimeMs + ", lastFailTimeMs=" + this.lastFailTimeMs + ", inFlightCorrelationId=" + this.inFlightCorrelationId + ')';
        }
    }

    private static enum State {
        AWAITING_REQUEST,
        BACKING_OFF,
        READY;

    }
}

