/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.broker.stats;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.inlong.tubemq.corebase.daemon.AbstractDaemonService;
import org.apache.inlong.tubemq.corebase.metric.TrafficStatsUnit;
import org.apache.inlong.tubemq.corebase.metric.impl.LongOnlineCounter;
import org.apache.inlong.tubemq.server.broker.stats.TrafficInfo;
import org.apache.inlong.tubemq.server.broker.stats.TrafficService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrafficStatsService
extends AbstractDaemonService
implements TrafficService {
    private static final long MAX_WRITING_WAIT_DLT = 5000L;
    private final Logger logger;
    private final String statsCat;
    private final WritableUnit[] switchableUnits = new WritableUnit[2];
    private final AtomicInteger writableIndex = new AtomicInteger(0);

    public TrafficStatsService(String logFileName, String countType, long scanIntervalMs) {
        super(logFileName, scanIntervalMs);
        this.statsCat = countType;
        this.logger = logFileName == null ? LoggerFactory.getLogger(TrafficStatsService.class) : LoggerFactory.getLogger((String)logFileName);
        this.switchableUnits[0] = new WritableUnit();
        this.switchableUnits[1] = new WritableUnit();
        super.start();
    }

    protected void loopProcess(StringBuilder strBuff) {
        try {
            this.output2file(this.writableIndex.getAndIncrement());
        }
        catch (Throwable throwable) {
            this.logger.error("[Traffic Stats] Daemon commit thread throw error ", throwable);
        }
    }

    @Override
    public void close(long waitTimeMs) {
        if (super.stop()) {
            return;
        }
        this.output2file(this.writableIndex.get() - 1);
        this.output2file(this.writableIndex.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Map<String, TrafficInfo> trafficInfos) {
        WritableUnit selectedUnit = this.switchableUnits[this.getIndex()];
        selectedUnit.refCnt.incValue();
        try {
            ConcurrentHashMap<String, TrafficStatsUnit> tmpStatsSetMap = selectedUnit.statsUnitMap;
            for (Map.Entry<String, TrafficInfo> entry : trafficInfos.entrySet()) {
                TrafficStatsUnit trafficStatsSet = tmpStatsSetMap.get(entry.getKey());
                if (trafficStatsSet == null) {
                    TrafficStatsUnit tmpStatsSet = new TrafficStatsUnit("msg_cnt", "msg_size", null);
                    trafficStatsSet = tmpStatsSetMap.putIfAbsent(entry.getKey(), tmpStatsSet);
                    if (trafficStatsSet == null) {
                        trafficStatsSet = tmpStatsSet;
                    }
                }
                trafficStatsSet.addMsgCntAndSize(entry.getValue().getMsgCount(), entry.getValue().getMsgSize());
            }
        }
        finally {
            selectedUnit.refCnt.decValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(String statsKey, long msgCnt, long msgSize) {
        WritableUnit selectedUnit = this.switchableUnits[this.getIndex()];
        selectedUnit.refCnt.incValue();
        try {
            TrafficStatsUnit tmpStatsSet;
            ConcurrentHashMap<String, TrafficStatsUnit> tmpStatsSetMap = selectedUnit.statsUnitMap;
            TrafficStatsUnit trafficStatsSet = tmpStatsSetMap.get(statsKey);
            if (trafficStatsSet == null && (trafficStatsSet = tmpStatsSetMap.putIfAbsent(statsKey, tmpStatsSet = new TrafficStatsUnit("msg_cnt", "msg_size", null))) == null) {
                trafficStatsSet = tmpStatsSet;
            }
            trafficStatsSet.addMsgCntAndSize(msgCnt, msgSize);
        }
        finally {
            selectedUnit.refCnt.decValue();
        }
    }

    private void output2file(int readIndex) {
        WritableUnit selectedUnit = this.switchableUnits[this.getIndex(readIndex)];
        if (selectedUnit == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < 5000L) {
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException e) {
                break;
            }
            if (selectedUnit.refCnt.getValue() > 0L) continue;
        }
        ConcurrentHashMap<String, TrafficStatsUnit> statsMap = selectedUnit.statsUnitMap;
        for (Map.Entry entry : statsMap.entrySet()) {
            this.logger.info("{}#{}#{}#{}", new Object[]{this.statsCat, entry.getKey(), ((TrafficStatsUnit)entry.getValue()).msgCnt.getValue(), ((TrafficStatsUnit)entry.getValue()).msgSize.getValue()});
        }
        statsMap.clear();
    }

    private int getIndex() {
        return this.getIndex(this.writableIndex.get());
    }

    private int getIndex(int origIndex) {
        return Math.abs(origIndex % 2);
    }

    private static class WritableUnit {
        public LongOnlineCounter refCnt = new LongOnlineCounter("ref_count", null);
        protected ConcurrentHashMap<String, TrafficStatsUnit> statsUnitMap = new ConcurrentHashMap(512);

        private WritableUnit() {
        }
    }
}

