/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.broker.utils;

import java.io.IOException;
import org.apache.inlong.tubemq.corebase.utils.AbstractSamplePrint;
import org.slf4j.Logger;

public class DiskSamplePrint
extends AbstractSamplePrint {
    private final Logger logger;

    public DiskSamplePrint(Logger logger) {
        this.logger = logger;
    }

    public DiskSamplePrint(Logger logger, long sampleDetailDur, long sampleResetDur, long maxDetailCount, long maxTotalCount) {
        super(sampleDetailDur, sampleResetDur, maxDetailCount, maxTotalCount);
        this.logger = logger;
    }

    public void printExceptionCaught(Throwable e) {
        if (e != null) {
            if (e instanceof IOException) {
                long now = System.currentTimeMillis();
                long diffTime = now - this.lastLogTime.get();
                long curPrintCnt = this.totalPrintCount.incrementAndGet();
                if (curPrintCnt < this.maxTotalCount) {
                    if (diffTime < this.sampleDetailDur && curPrintCnt < this.maxDetailCount) {
                        this.logger.error("[File Store] Append message in file failed ", e);
                    } else {
                        this.logger.error(this.sBuilder.append("[File Store] Append message in file failed 2 ").append(e.toString()).toString());
                        this.sBuilder.delete(0, this.sBuilder.length());
                    }
                }
                if (diffTime > this.sampleResetDur && this.lastLogTime.compareAndSet(now - diffTime, now)) {
                    this.totalPrintCount.set(0L);
                }
            } else {
                long curPrintCnt = this.totalUncheckCount.incrementAndGet();
                if (curPrintCnt < this.maxUncheckDetailCount) {
                    this.logger.error("[File Store] Append message in file failed 3 is ", e);
                } else {
                    this.logger.error(this.sBuilder.append("[File Store] Append message in file failed 4 is ").append(e.toString()).toString());
                    this.sBuilder.delete(0, this.sBuilder.length());
                }
            }
        }
    }

    public void printExceptionCaught(Throwable e, String storeKey, String partitionId) {
        if (e != null) {
            if (e instanceof IOException) {
                long now = System.currentTimeMillis();
                long diffTime = now - this.lastLogTime.get();
                long curPrintCnt = this.totalPrintCount.incrementAndGet();
                if (curPrintCnt < this.maxTotalCount) {
                    if (diffTime < this.sampleDetailDur && curPrintCnt < this.maxDetailCount) {
                        this.logger.warn(this.sBuilder.append("[File Store] Get message failure for IOException, storeKey=").append(storeKey).append(", partitionId=").append(partitionId).toString(), e);
                    } else {
                        this.logger.warn(this.sBuilder.append("[File Store] Get message failure for IOException 2, storeKey=").append(storeKey).append(", partitionId=").append(partitionId).append(", error = ").append(e.toString()).toString());
                    }
                    this.sBuilder.delete(0, this.sBuilder.length());
                }
                if (diffTime > this.sampleResetDur && this.lastLogTime.compareAndSet(now - diffTime, now)) {
                    this.totalPrintCount.set(0L);
                }
            } else {
                long curPrintCnt = this.totalUncheckCount.incrementAndGet();
                if (curPrintCnt < this.maxUncheckDetailCount) {
                    this.logger.warn(this.sBuilder.append("[File Store] Get message failure for Exception 3, storeKey=").append(storeKey).append(", partitionId=").append(partitionId).toString(), e);
                } else {
                    this.logger.warn(this.sBuilder.append("[File Store] Get message failure for Exception 4, storeKey=").append(storeKey).append(", partitionId=").append(partitionId).append(", error = ").append(e.toString()).toString());
                }
                this.sBuilder.delete(0, this.sBuilder.length());
            }
        }
    }

    public void printWarn(String err) {
    }

    public void printError(String err) {
    }
}

