/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.common.heartbeat;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.server.common.exception.HeartbeatException;
import org.apache.inlong.tubemq.server.common.heartbeat.TimeoutInfo;
import org.apache.inlong.tubemq.server.common.heartbeat.TimeoutListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatManager {
    private static final Logger logger = LoggerFactory.getLogger(HeartbeatManager.class);
    private final ConcurrentHashMap<String, TimeoutInfo> brokerRegMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, TimeoutInfo> producerRegMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, TimeoutInfo> consumerRegMap = new ConcurrentHashMap();
    private final ExecutorService timeoutScanService = Executors.newCachedThreadPool();
    private long brokerTimeoutDlt = 0L;
    private long producerTimeoutDlt = 0L;
    private long consumerTimeoutDlt = 0L;
    private boolean isStopped = false;

    public ConcurrentHashMap<String, TimeoutInfo> getBrokerRegMap() {
        return this.brokerRegMap;
    }

    public ConcurrentHashMap<String, TimeoutInfo> getProducerRegMap() {
        return this.producerRegMap;
    }

    public ConcurrentHashMap<String, TimeoutInfo> getConsumerRegMap() {
        return this.consumerRegMap;
    }

    public long getConsumerTimeoutDlt() {
        return this.consumerTimeoutDlt;
    }

    public void regBrokerCheckBusiness(long timeout, TimeoutListener listener) {
        this.brokerTimeoutDlt = timeout;
        this.registerCheckBusiness("Broker Node", this.brokerRegMap, listener);
    }

    public void regProducerCheckBusiness(long timeout, TimeoutListener listener) {
        this.producerTimeoutDlt = timeout;
        this.registerCheckBusiness("Producer Node", this.producerRegMap, listener);
    }

    public void regConsumerCheckBusiness(long timeout, TimeoutListener listener) {
        this.consumerTimeoutDlt = timeout;
        this.registerCheckBusiness("Consumer Node", this.consumerRegMap, listener);
    }

    private void registerCheckBusiness(final String businessType, final Map<String, TimeoutInfo> nodeMap, final TimeoutListener listener) {
        this.timeoutScanService.submit(new Runnable(){

            @Override
            public void run() {
                while (!HeartbeatManager.this.isStopped) {
                    try {
                        long currentTime = System.currentTimeMillis();
                        HashSet removedNodeKey = new HashSet();
                        for (Map.Entry entry : nodeMap.entrySet()) {
                            if (TStringUtils.isBlank((String)((String)entry.getKey())) || entry.getValue() == null || currentTime < ((TimeoutInfo)entry.getValue()).getTimeoutTime()) continue;
                            removedNodeKey.add(entry.getKey());
                        }
                        if (!removedNodeKey.isEmpty()) {
                            for (String nodeKey : removedNodeKey) {
                                TimeoutInfo timeoutInfo = (TimeoutInfo)nodeMap.get(nodeKey);
                                if (timeoutInfo == null || currentTime < timeoutInfo.getTimeoutTime()) continue;
                                nodeMap.remove(nodeKey);
                                listener.onTimeout(nodeKey, timeoutInfo);
                            }
                        }
                        Thread.sleep(1000L);
                    }
                    catch (Throwable t) {
                        logger.error(new StringBuilder(256).append(businessType).append(" heartbeat scan error!").toString(), t);
                    }
                }
            }
        });
    }

    public TimeoutInfo regBrokerNode(String nodeId, String createId) {
        return this.brokerRegMap.put(nodeId, new TimeoutInfo(createId, this.brokerTimeoutDlt));
    }

    public TimeoutInfo regProducerNode(String nodeId) {
        return this.producerRegMap.put(nodeId, new TimeoutInfo(this.producerTimeoutDlt));
    }

    public TimeoutInfo regConsumerNode(String nodeId) {
        return this.consumerRegMap.put(nodeId, new TimeoutInfo(this.consumerTimeoutDlt));
    }

    public TimeoutInfo regConsumerNode(String nodeId, String consumerId, String partStr) {
        return this.consumerRegMap.put(nodeId, new TimeoutInfo(consumerId, partStr, this.consumerTimeoutDlt));
    }

    public boolean unRegBrokerNode(String nodeId, String createId) {
        TimeoutInfo timeoutInfo = this.brokerRegMap.get(nodeId);
        if (timeoutInfo == null) {
            return true;
        }
        if (!createId.equals(timeoutInfo.getSecondKey())) {
            return false;
        }
        timeoutInfo = this.brokerRegMap.remove(nodeId);
        return true;
    }

    public TimeoutInfo unRegProducerNode(String nodeId) {
        return this.producerRegMap.remove(nodeId);
    }

    public TimeoutInfo unRegConsumerNode(String nodeId) {
        return this.consumerRegMap.remove(nodeId);
    }

    public boolean updBrokerNode(String nodeId, String createId, StringBuilder sBuffer, ProcessResult result) {
        TimeoutInfo timeoutInfo = this.brokerRegMap.get(nodeId);
        if (timeoutInfo == null) {
            result.setFailResult(411, sBuffer.append("Invalid node id:").append(nodeId).append(", you have to append node first!").toString());
            sBuffer.delete(0, sBuffer.length());
            return result.isSuccess();
        }
        if (!createId.equals(timeoutInfo.getSecondKey())) {
            result.setFailResult(411, sBuffer.append("Invalid node block id:").append(nodeId).append(", you have to append node first!").toString());
            sBuffer.delete(0, sBuffer.length());
            return result.isSuccess();
        }
        timeoutInfo.updTimeoutTime(this.brokerTimeoutDlt);
        result.setSuccResult(null);
        return result.isSuccess();
    }

    public void updProducerNode(String nodeId) throws HeartbeatException {
        TimeoutInfo timeoutInfo = this.producerRegMap.get(nodeId);
        if (timeoutInfo == null) {
            throw new HeartbeatException(new StringBuilder(512).append("Invalid node id:").append(nodeId).append(", you have to append node first!").toString());
        }
        timeoutInfo.updTimeoutTime(this.producerTimeoutDlt);
    }

    public void updConsumerNode(String nodeId) throws HeartbeatException {
        TimeoutInfo timeoutInfo = this.consumerRegMap.get(nodeId);
        if (timeoutInfo == null) {
            throw new HeartbeatException(new StringBuilder(512).append("Invalid node id:").append(nodeId).append(", you have to append node first!").toString());
        }
        timeoutInfo.updTimeoutTime(this.consumerTimeoutDlt);
    }

    public void stop() {
        this.isStopped = true;
    }

    public void clearAllHeartbeat() {
        this.brokerRegMap.clear();
        this.producerRegMap.clear();
        this.consumerRegMap.clear();
    }
}

