/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.common.statusdef;

public enum TopicStatus {
    STATUS_TOPIC_UNDEFINED(-2, "Undefined"),
    STATUS_TOPIC_OK(0, "Normal"),
    STATUS_TOPIC_SOFT_DELETE(1, "Soft deleted"),
    STATUS_TOPIC_SOFT_REMOVE(2, "Soft removed"),
    STATUS_TOPIC_HARD_REMOVE(3, "Hard removed");

    private int code;
    private String description;

    private TopicStatus(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static TopicStatus valueOf(int code) {
        for (TopicStatus status : TopicStatus.values()) {
            if (status.getCode() != code) continue;
            return status;
        }
        throw new IllegalArgumentException(String.format("unknown topic status code %s", code));
    }
}

