/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.common.utils;

import java.util.HashSet;
import java.util.Set;
import org.apache.inlong.tubemq.corebase.cluster.BrokerInfo;
import org.apache.inlong.tubemq.corebase.cluster.Partition;
import org.apache.inlong.tubemq.corebase.protobuf.generated.ClientMaster;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.corebase.utils.Tuple2;
import org.apache.inlong.tubemq.server.master.nodemanage.nodebroker.BrokerRunManager;

public class ClientSyncInfo {
    private boolean updated = false;
    private long brokerConfigId = -2L;
    private long topicMetaInfoId = -2L;
    private long lstAssignedTime = -2L;
    private boolean repPartInfo = false;
    private final Set<Partition> subPartSet = new HashSet<Partition>();

    public void updSubRepInfo(BrokerRunManager brokerRunManager, ClientMaster.ClientSubRepInfo clientSubRepInfo) {
        if (clientSubRepInfo == null) {
            return;
        }
        if (clientSubRepInfo.hasBrokerConfigId()) {
            this.brokerConfigId = clientSubRepInfo.getBrokerConfigId();
            this.updated = true;
        }
        if (clientSubRepInfo.hasTopicMetaInfoId()) {
            this.topicMetaInfoId = clientSubRepInfo.getTopicMetaInfoId();
            this.updated = true;
        }
        if (clientSubRepInfo.hasLstAssignedTime()) {
            this.lstAssignedTime = clientSubRepInfo.getLstAssignedTime();
            this.updated = true;
        }
        if (clientSubRepInfo.hasReportSubInfo()) {
            this.repPartInfo = clientSubRepInfo.getReportSubInfo();
            if (this.repPartInfo) {
                for (String info : clientSubRepInfo.getPartSubInfoList()) {
                    String[] strPartInfoSet;
                    if (TStringUtils.isBlank((String)info)) continue;
                    String[] strInfo = info.split("#");
                    for (String partStr : strPartInfoSet = strInfo[1].split(",")) {
                        String[] strPartInfo = partStr.split(":");
                        BrokerInfo brokerInfo = brokerRunManager.getBrokerInfo(Integer.parseInt(strPartInfo[0]));
                        if (brokerInfo == null) continue;
                        this.subPartSet.add(new Partition(brokerInfo, strInfo[0], Integer.parseInt(strPartInfo[1])));
                    }
                }
            }
            this.updated = true;
        }
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public long getBrokerConfigId() {
        return this.brokerConfigId;
    }

    public long getTopicMetaInfoId() {
        return this.topicMetaInfoId;
    }

    public long getLstAssignedTime() {
        return this.lstAssignedTime;
    }

    public Tuple2<Boolean, Set<Partition>> getRepSubInfo() {
        return new Tuple2((Object)this.repPartInfo, this.subPartSet);
    }

    public void clear() {
        this.updated = false;
        this.brokerConfigId = -2L;
        this.topicMetaInfoId = -2L;
        this.lstAssignedTime = -2L;
        this.repPartInfo = false;
        this.subPartSet.clear();
    }
}

