/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.tubemq.corebase.utils.DateTimeConvertUtils;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.server.common.utils.SerialIdUtils;

public class BaseEntity
implements Serializable,
Cloneable {
    private long dataVersionId = -2L;
    private AtomicLong serialId = new AtomicLong(-2L);
    private String createUser = "";
    private Date createDate = null;
    private String modifyUser = "";
    private Date modifyDate = null;
    private String attributes = "";
    private String createDateStr = "";
    private String modifyDateStr = "";

    public BaseEntity() {
    }

    public BaseEntity(String createUser, Date createDate) {
        this(0L, createUser, createDate, createUser, createDate);
    }

    public BaseEntity(BaseEntity other) {
        this.dataVersionId = other.dataVersionId;
        this.setCreateInfo(other.createUser, other.createDate);
        this.setModifyInfo(other.modifyUser, other.modifyDate);
        this.serialId.set(other.serialId.get());
        this.attributes = other.attributes;
    }

    public BaseEntity(long dataVersionId, String createUser, Date createDate) {
        this(dataVersionId, createUser, createDate, createUser, createDate);
    }

    public BaseEntity(String createUser, Date createDate, String modifyUser, Date modifyDate) {
        this(0L, createUser, createDate, modifyUser, modifyDate);
    }

    public BaseEntity(long dataVersionId, String createUser, Date createDate, String modifyUser, Date modifyDate) {
        this.dataVersionId = dataVersionId;
        this.setCreateInfo(createUser, createDate);
        this.setModifyInfo(modifyUser, modifyDate);
        this.updSerialId();
    }

    public boolean updBaseModifyInfo(BaseEntity opInfoEntity) {
        boolean changed = false;
        if (TStringUtils.isNotBlank((String)opInfoEntity.getModifyUser()) && !Objects.equals(this.modifyUser, opInfoEntity.getModifyUser())) {
            changed = true;
            this.modifyUser = opInfoEntity.getModifyUser();
        }
        if (opInfoEntity.getModifyDate() != null && !Objects.equals(this.modifyDate, opInfoEntity.getModifyDate())) {
            changed = true;
            this.setModifyDate(opInfoEntity.getModifyDate());
        }
        if (TStringUtils.isNotBlank((String)opInfoEntity.getAttributes()) && !Objects.equals(this.attributes, opInfoEntity.getAttributes())) {
            changed = true;
            this.attributes = opInfoEntity.getAttributes();
        }
        return changed;
    }

    public boolean updQueryKeyInfo(long newDataVerId, String newCreateUser, String newModifyUser) {
        boolean changed = false;
        if (newDataVerId != -2L && this.dataVersionId != newDataVerId) {
            changed = true;
            this.dataVersionId = newDataVerId;
        }
        if (TStringUtils.isNotBlank((String)newCreateUser) && !Objects.equals(this.createUser, newCreateUser)) {
            changed = true;
            this.createUser = newCreateUser;
        }
        if (TStringUtils.isNotBlank((String)newModifyUser) && !Objects.equals(this.modifyUser, newModifyUser)) {
            changed = true;
            this.modifyUser = newModifyUser;
        }
        return changed;
    }

    public void setDataVersionId(long dataVersionId) {
        this.dataVersionId = dataVersionId;
    }

    public void setKeyAndVal(String key, String value) {
        this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)key, (String)value);
    }

    public String getValueByKey(String key) {
        return TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)key);
    }

    public String getAttributes() {
        return this.attributes;
    }

    public void setCreateInfo(String creator, Date createDate) {
        if (TStringUtils.isNotBlank((String)creator)) {
            this.createUser = creator;
        }
        this.setCreateDate(createDate);
    }

    public void setModifyInfo(String modifyUser, Date modifyDate) {
        if (TStringUtils.isNotBlank((String)modifyUser)) {
            this.modifyUser = modifyUser;
        }
        this.setModifyDate(modifyDate);
    }

    public void setAttributes(String attributes) {
        this.attributes = attributes;
    }

    public String getCreateUser() {
        return this.createUser;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public long getDataVerId() {
        return this.dataVersionId;
    }

    public long getSerialId() {
        return this.serialId.get();
    }

    protected void updSerialId() {
        SerialIdUtils.updTimeStampSerialIdValue(this.serialId);
    }

    public String getModifyUser() {
        return this.modifyUser;
    }

    public Date getModifyDate() {
        return this.modifyDate;
    }

    public String getCreateDateStr() {
        return this.createDateStr;
    }

    public String getModifyDateStr() {
        return this.modifyDateStr;
    }

    public String toJsonString(Gson gson) {
        return gson.toJson((Object)this);
    }

    public String toString() {
        Gson gson = new GsonBuilder().create();
        return this.toJsonString(gson);
    }

    public boolean isMatched(BaseEntity target) {
        if (target == null) {
            return true;
        }
        return !(target.getDataVerId() != -2L && this.getDataVerId() != target.getDataVerId() || !TStringUtils.isBlank((String)target.getCreateUser()) && !target.getCreateUser().equals(this.createUser) || !TStringUtils.isBlank((String)target.getModifyUser()) && !target.getModifyUser().equals(this.modifyUser));
    }

    public StringBuilder toWebJsonStr(StringBuilder sBuilder, boolean isLongName) {
        if (isLongName) {
            sBuilder.append(",\"dataVersionId\":").append(this.dataVersionId).append(",\"serialId\":").append(this.serialId.get()).append(",\"createUser\":\"").append(this.createUser).append("\"").append(",\"createDate\":\"").append(this.createDateStr).append("\"").append(",\"modifyUser\":\"").append(this.modifyUser).append("\"").append(",\"modifyDate\":\"").append(this.modifyDateStr).append("\"");
        } else {
            sBuilder.append(",\"dVerId\":").append(this.dataVersionId).append(",\"serialId\":").append(this.serialId.get()).append(",\"cur\":\"").append(this.createUser).append("\"").append(",\"cDate\":\"").append(this.createDateStr).append("\"").append(",\"mur\":\"").append(this.modifyUser).append("\"").append(",\"mDate\":\"").append(this.modifyDateStr).append("\"");
        }
        return sBuilder;
    }

    public void getConfigureInfo(Map<String, String> paramMap, boolean isLongName) {
        if (this.dataVersionId != -2L) {
            paramMap.put(isLongName ? "dataVersionId" : "dVerId", String.valueOf(this.dataVersionId));
        }
        if (this.serialId.get() != -2L) {
            paramMap.put(isLongName ? "serialId" : "serialId", String.valueOf(this.serialId.get()));
        }
        if (TStringUtils.isNotBlank((String)this.createUser)) {
            paramMap.put(isLongName ? "createUser" : "cur", this.createUser);
        }
        if (TStringUtils.isNotBlank((String)this.createDateStr)) {
            paramMap.put(isLongName ? "createDate" : "cDate", this.createDateStr);
        }
        if (TStringUtils.isNotBlank((String)this.modifyUser)) {
            paramMap.put(isLongName ? "modifyUser" : "mur", this.modifyUser);
        }
        if (TStringUtils.isNotBlank((String)this.modifyDateStr)) {
            paramMap.put(isLongName ? "modifyDate" : "mDate", this.modifyDateStr);
        }
    }

    private void setModifyDate(Date date) {
        if (date == null) {
            return;
        }
        this.modifyDate = date;
        this.modifyDateStr = DateTimeConvertUtils.date2yyyyMMddHHmmss((Date)date);
    }

    private void setCreateDate(Date date) {
        if (date == null) {
            return;
        }
        this.createDate = date;
        this.createDateStr = DateTimeConvertUtils.date2yyyyMMddHHmmss((Date)date);
    }

    public boolean isDataEquals(BaseEntity other) {
        return this.dataVersionId == other.dataVersionId && Objects.equals(this.createUser, other.createUser) && Objects.equals(this.createDateStr, other.createDateStr) && Objects.equals(this.modifyUser, other.modifyUser) && Objects.equals(this.modifyDateStr, other.modifyDateStr);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseEntity)) {
            return false;
        }
        BaseEntity that = (BaseEntity)o;
        return this.serialId.get() == that.serialId.get() && this.isDataEquals(that);
    }

    public int hashCode() {
        return Objects.hash(this.dataVersionId, this.serialId.get(), this.createUser, this.createDate, this.modifyUser, this.modifyDate, this.attributes);
    }

    public BaseEntity clone() {
        try {
            BaseEntity copy = (BaseEntity)super.clone();
            if (copy != null) {
                copy.serialId = new AtomicLong(this.serialId.get());
            }
            return copy;
        }
        catch (Throwable e) {
            return null;
        }
    }
}

