/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.metamanage.metastore.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.server.master.metamanage.DataOpErrCode;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.GroupResCtrlEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.mapper.GroupResCtrlMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbsGroupResCtrlMapperImpl
implements GroupResCtrlMapper {
    protected static final Logger logger = LoggerFactory.getLogger(AbsGroupResCtrlMapperImpl.class);
    private final ConcurrentHashMap<String, GroupResCtrlEntity> groupBaseCtrlCache = new ConcurrentHashMap();

    @Override
    public boolean addGroupResCtrlConf(GroupResCtrlEntity entity, StringBuilder strBuff, ProcessResult result) {
        GroupResCtrlEntity curEntity = this.groupBaseCtrlCache.get(entity.getGroupName());
        if (curEntity != null) {
            result.setFailResult(DataOpErrCode.DERR_EXISTED.getCode(), strBuff.append("Existed record found for groupName(").append(entity.getGroupName()).append(")!").toString());
            strBuff.delete(0, strBuff.length());
            return result.isSuccess();
        }
        if (this.putConfig2Persistent(entity, strBuff, result)) {
            this.groupBaseCtrlCache.put(entity.getGroupName(), entity);
        }
        return result.isSuccess();
    }

    @Override
    public boolean updGroupResCtrlConf(GroupResCtrlEntity entity, StringBuilder strBuff, ProcessResult result) {
        GroupResCtrlEntity curEntity = this.groupBaseCtrlCache.get(entity.getGroupName());
        if (curEntity == null) {
            result.setFailResult(DataOpErrCode.DERR_NOT_EXIST.getCode(), strBuff.append("Not found group control configure for groupName(").append(entity.getGroupName()).append(")!").toString());
            strBuff.delete(0, strBuff.length());
            return result.isSuccess();
        }
        GroupResCtrlEntity newEntity = curEntity.clone();
        newEntity.updBaseModifyInfo(entity);
        if (!newEntity.updModifyInfo(entity.getDataVerId(), entity.getResCheckStatus(), entity.getAllowedBrokerClientRate(), entity.getQryPriorityId(), entity.getFlowCtrlStatus(), entity.getRuleCnt(), entity.getFlowCtrlInfo())) {
            result.setFailResult(DataOpErrCode.DERR_UNCHANGED.getCode(), "Group control configure not changed!");
            return result.isSuccess();
        }
        if (this.putConfig2Persistent(newEntity, strBuff, result)) {
            this.groupBaseCtrlCache.put(newEntity.getGroupName(), newEntity);
            result.setSuccResult(null);
        }
        return result.isSuccess();
    }

    @Override
    public boolean delGroupResCtrlConf(String groupName, StringBuilder strBuff, ProcessResult result) {
        GroupResCtrlEntity curEntity = this.groupBaseCtrlCache.get(groupName);
        if (curEntity == null) {
            result.setSuccResult(null);
            return true;
        }
        this.delConfigFromPersistent(groupName, strBuff);
        this.groupBaseCtrlCache.remove(groupName);
        result.setSuccResult(null);
        return true;
    }

    @Override
    public GroupResCtrlEntity getGroupResCtrlConf(String groupName) {
        return this.groupBaseCtrlCache.get(groupName);
    }

    @Override
    public Map<String, GroupResCtrlEntity> getGroupResCtrlConf(Set<String> groupNameSet, GroupResCtrlEntity qryEntry) {
        HashMap<String, GroupResCtrlEntity> retMap = new HashMap<String, GroupResCtrlEntity>();
        if (groupNameSet == null || groupNameSet.isEmpty()) {
            for (GroupResCtrlEntity entry : this.groupBaseCtrlCache.values()) {
                if (entry == null || qryEntry != null && !entry.isMatched(qryEntry)) continue;
                retMap.put(entry.getGroupName(), entry);
            }
        } else {
            for (String groupName : groupNameSet) {
                GroupResCtrlEntity entry = this.groupBaseCtrlCache.get(groupName);
                if (entry == null || qryEntry != null && !entry.isMatched(qryEntry)) continue;
                retMap.put(entry.getGroupName(), entry);
            }
        }
        return retMap;
    }

    protected void clearCachedData() {
        this.groupBaseCtrlCache.clear();
    }

    protected void putRecord2Caches(GroupResCtrlEntity entity) {
        this.groupBaseCtrlCache.put(entity.getGroupName(), entity);
    }

    protected abstract boolean putConfig2Persistent(GroupResCtrlEntity var1, StringBuilder var2, ProcessResult var3);

    protected abstract boolean delConfigFromPersistent(String var1, StringBuilder var2);
}

