/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.metamanage.metastore.impl.zkimpl;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.server.broker.stats.BrokerSrvStatsHolder;
import org.apache.inlong.tubemq.server.common.exception.LoadMetaException;
import org.apache.inlong.tubemq.server.common.zookeeper.ZKUtil;
import org.apache.inlong.tubemq.server.common.zookeeper.ZooKeeperWatcher;
import org.apache.inlong.tubemq.server.master.metamanage.DataOpErrCode;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.BrokerConfEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.impl.AbsBrokerConfigMapperImpl;
import org.apache.zookeeper.KeeperException;

public class ZKBrokerConfigMapperImpl
extends AbsBrokerConfigMapperImpl {
    private final ZooKeeperWatcher zkWatcher;
    private final String brokerCfgRootDir;

    public ZKBrokerConfigMapperImpl(String metaNodePrefix, ZooKeeperWatcher zkWatcher, StringBuilder strBuff) {
        this.zkWatcher = zkWatcher;
        this.brokerCfgRootDir = strBuff.append(metaNodePrefix).append("/").append("brokerConfig").toString();
        strBuff.delete(0, strBuff.length());
    }

    @Override
    public void close() {
        this.clearCachedData();
        logger.info("[ZK Impl] close broker configure finished!");
    }

    @Override
    public void loadConfig(StringBuilder strBuff) throws LoadMetaException {
        long totalCnt = 0L;
        logger.info("[ZK Impl] load broker configure start...");
        this.clearCachedData();
        List<String> childNodes = ZKUtil.getChildren(this.zkWatcher, this.brokerCfgRootDir);
        if (childNodes == null) {
            logger.info("[ZK Impl] Not found broker configure from ZooKeeper");
            return;
        }
        Gson gson = new Gson();
        Type type = new TypeToken<BrokerConfEntity>(){}.getType();
        for (String itemKey : childNodes) {
            String confStr;
            if (TStringUtils.isEmpty((String)itemKey)) continue;
            try {
                confStr = ZKUtil.readDataMaybeNull(this.zkWatcher, strBuff.append(this.brokerCfgRootDir).append("/").append(itemKey).toString());
                strBuff.delete(0, strBuff.length());
            }
            catch (KeeperException e) {
                BrokerSrvStatsHolder.incZKExcCnt();
                logger.error("KeeperException during load broker configure from ZooKeeper", (Throwable)e);
                throw new LoadMetaException(e.getMessage());
            }
            if (confStr == null) continue;
            this.putRecord2Caches((BrokerConfEntity)gson.fromJson(confStr, type));
            ++totalCnt;
        }
        logger.info(strBuff.append("[ZK Impl] loaded ").append(totalCnt).append(" broker configure successfully...").toString());
        strBuff.delete(0, strBuff.length());
    }

    @Override
    protected boolean putConfig2Persistent(BrokerConfEntity entity, StringBuilder strBuff, ProcessResult result) {
        String entityStr = entity.toString();
        String confNode = strBuff.append(this.brokerCfgRootDir).append("/").append(entity.getBrokerId()).toString();
        strBuff.delete(0, strBuff.length());
        try {
            ZKUtil.updatePersistentPath(this.zkWatcher, confNode, entityStr);
        }
        catch (Throwable t) {
            BrokerSrvStatsHolder.incZKExcCnt();
            logger.error("[ZK Impl] put broker configure failure ", t);
            result.setFailResult(DataOpErrCode.DERR_STORE_ABNORMAL.getCode(), strBuff.append("Put broker configure failure: ").append(t.getMessage()).toString());
            strBuff.delete(0, strBuff.length());
            return result.isSuccess();
        }
        result.setSuccResult(null);
        return result.isSuccess();
    }

    @Override
    protected boolean delConfigFromPersistent(int brokerId, StringBuilder strBuff) {
        ZKUtil.delZNode(this.zkWatcher, strBuff.append(this.brokerCfgRootDir).append("/").append(brokerId).toString());
        strBuff.delete(0, strBuff.length());
        return true;
    }
}

