/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.web.action.screen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.tubemq.corebase.cluster.BrokerInfo;
import org.apache.inlong.tubemq.corebase.cluster.Partition;
import org.apache.inlong.tubemq.corebase.cluster.ProducerInfo;
import org.apache.inlong.tubemq.corebase.cluster.TopicInfo;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.corebase.utils.Tuple2;
import org.apache.inlong.tubemq.corebase.utils.Tuple3;
import org.apache.inlong.tubemq.corerpc.exception.StandbyException;
import org.apache.inlong.tubemq.server.master.TMaster;
import org.apache.inlong.tubemq.server.master.metamanage.MetaDataService;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.TopicDeployEntity;
import org.apache.inlong.tubemq.server.master.nodemanage.nodebroker.BrokerRunManager;
import org.apache.inlong.tubemq.server.master.nodemanage.nodebroker.TopicPSInfoManager;
import org.apache.inlong.tubemq.server.master.nodemanage.nodeconsumer.ConsumerInfoHolder;
import org.apache.inlong.tubemq.server.master.web.simplemvc.Action;
import org.apache.inlong.tubemq.server.master.web.simplemvc.RequestContext;

public class Master
implements Action {
    private final TMaster master;

    public Master(TMaster master) {
        this.master = master;
    }

    @Override
    public void execute(RequestContext requestContext) {
        StringBuilder sBuilder = new StringBuilder(512);
        try {
            HttpServletRequest req = requestContext.getReq();
            if (this.master.isStopped()) {
                throw new Exception("Sever is stopping...");
            }
            MetaDataService defMetaDataService = this.master.getMetaDataService();
            if (!defMetaDataService.isSelfMaster()) {
                throw new StandbyException("Please send your request to the master Node.");
            }
            String type = req.getParameter("type");
            if ("consumer".equals(type)) {
                this.getConsumerListInfo(req, sBuilder);
            } else if ("sub_info".equals(type)) {
                this.getConsumerSubInfo(req, sBuilder);
            } else if ("producer".equals(type)) {
                this.getProducerListInfo(req, sBuilder);
            } else if ("broker".equals(type)) {
                this.innGetBrokerInfo(req, sBuilder, true);
            } else if ("newBroker".equals(type)) {
                this.innGetBrokerInfo(req, sBuilder, false);
            } else if ("topic_pub".equals(type)) {
                this.getTopicPubInfo(req, sBuilder);
            } else if ("unbalance_group".equals(type)) {
                this.getUnbalanceGroupInfo(sBuilder);
            } else {
                sBuilder.append("Unsupported request type : ").append(type);
            }
            requestContext.put("sb", sBuilder.toString());
        }
        catch (Exception e) {
            requestContext.put("sb", "Bad request from client. " + e.getMessage());
        }
    }

    private void getConsumerListInfo(HttpServletRequest req, StringBuilder sBuilder) {
        block4: {
            ConsumerInfoHolder consumerHolder = this.master.getConsumerHolder();
            String group = req.getParameter("group");
            if (group == null) break block4;
            int index = 1;
            List<String> consumerViewInfos = consumerHolder.getConsumerViewList(group);
            if (CollectionUtils.isEmpty(consumerViewInfos)) {
                List<String> groupList = consumerHolder.getAllGroupName();
                sBuilder.append("No such group.\n\nCurrent all groups(").append(groupList.size()).append("):\n");
                for (String currGroup : groupList) {
                    sBuilder.append(currGroup).append("\n");
                }
            } else {
                Collections.sort(consumerViewInfos);
                for (String consumerViewInfo : consumerViewInfos) {
                    if (consumerViewInfo == null) continue;
                    sBuilder.append(index).append(". ").append(consumerViewInfo).append("\n");
                    ++index;
                }
            }
        }
    }

    private void getConsumerSubInfo(HttpServletRequest req, StringBuilder sBuilder) {
        block8: {
            ConsumerInfoHolder consumerHolder = this.master.getConsumerHolder();
            String group = req.getParameter("group");
            if (group == null) break block8;
            List<Tuple2<String, Boolean>> consumerList = consumerHolder.getConsumerIdAndTlsInfos(group);
            if (CollectionUtils.isEmpty(consumerList)) {
                List<String> groupList = consumerHolder.getAllGroupName();
                sBuilder.append("No such group.\n\nCurrent all group(").append(groupList.size()).append("):\n");
                for (String currGroup : groupList) {
                    sBuilder.append(currGroup).append("\n");
                }
            } else {
                sBuilder.append("\n########################## Subscribe Relationship ############################\n\n");
                ConcurrentHashMap<String, Map<String, Map<String, Partition>>> currentSubInfoMap = this.master.getCurrentSubInfoMap();
                for (int i = 0; i < consumerList.size(); ++i) {
                    Tuple2<String, Boolean> consumer = consumerList.get(i);
                    sBuilder.append("*************** ").append(i + 1).append(". ").append((String)consumer.getF0()).append("#isOverTLS=").append(consumer.getF1()).append(" ***************");
                    Map topicSubMap = (Map)currentSubInfoMap.get(consumer.getF0());
                    if (topicSubMap != null) {
                        int totalSize = 0;
                        for (Map.Entry entry : topicSubMap.entrySet()) {
                            totalSize += ((Map)entry.getValue()).size();
                        }
                        sBuilder.append("(").append(totalSize).append(")\n\n");
                        for (Map.Entry entry : topicSubMap.entrySet()) {
                            Map partMap = (Map)entry.getValue();
                            if (partMap == null) continue;
                            for (Partition part : partMap.values()) {
                                sBuilder.append((String)consumer.getF0()).append("#").append(part.toString()).append("\n");
                            }
                        }
                    }
                    sBuilder.append("\n\n");
                }
            }
        }
    }

    private void getProducerListInfo(HttpServletRequest req, StringBuilder sBuilder) {
        String producerId = req.getParameter("id");
        if (producerId != null) {
            ProducerInfo producer = this.master.getProducerHolder().getProducerInfo(producerId);
            if (producer != null) {
                sBuilder.append(producer.toString());
            } else {
                sBuilder.append("No such producer!");
            }
        } else {
            TopicPSInfoManager topicPSInfoManager;
            Set<String> producerSet;
            String topic = req.getParameter("topic");
            if (topic != null && (producerSet = (topicPSInfoManager = this.master.getTopicPSInfoManager()).getTopicPubInfo(topic)) != null && !producerSet.isEmpty()) {
                int index = 1;
                for (String producer : producerSet) {
                    sBuilder.append(index).append(". ").append(producer).append("\n");
                    ++index;
                }
            }
        }
    }

    private void innGetBrokerInfo(HttpServletRequest req, StringBuilder sBuilder, boolean isOldRet) {
        Map<Integer, BrokerInfo> brokerInfoMap = null;
        BrokerRunManager brokerRunManager = this.master.getBrokerRunManager();
        String brokerIds = req.getParameter("ids");
        if (TStringUtils.isBlank((String)brokerIds)) {
            brokerInfoMap = brokerRunManager.getBrokerInfoMap(null);
        } else {
            String[] brokerIdArr = brokerIds.split(",");
            ArrayList<Integer> idList = new ArrayList<Integer>(brokerIdArr.length);
            for (String strId : brokerIdArr) {
                idList.add(Integer.parseInt(strId));
            }
            brokerInfoMap = brokerRunManager.getBrokerInfoMap(idList);
        }
        if (brokerInfoMap != null) {
            int index = 1;
            Tuple3 topicInfoTuple = new Tuple3();
            MetaDataService defMetaDataService = this.master.getMetaDataService();
            for (BrokerInfo broker : brokerInfoMap.values()) {
                sBuilder.append("\n################################## ").append(index).append(". ").append(broker.toString()).append(" ##################################\n");
                brokerRunManager.getPubBrokerPushedTopicInfo(broker.getBrokerId(), (Tuple3<Boolean, Boolean, List<TopicInfo>>)topicInfoTuple);
                Map<String, TopicDeployEntity> topicConfigMap = defMetaDataService.getBrokerTopicConfEntitySet(broker.getBrokerId());
                if (topicConfigMap == null) {
                    for (TopicInfo info : (List)topicInfoTuple.getF2()) {
                        sBuilder = info.toStrBuilderString(((Boolean)topicInfoTuple.getF0()).booleanValue(), ((Boolean)topicInfoTuple.getF1()).booleanValue(), sBuilder);
                        sBuilder.append("\n");
                    }
                } else {
                    for (TopicInfo info : (List)topicInfoTuple.getF2()) {
                        TopicDeployEntity bdbEntity = topicConfigMap.get(info.getTopic());
                        if (bdbEntity == null) {
                            sBuilder = info.toStrBuilderString(((Boolean)topicInfoTuple.getF0()).booleanValue(), ((Boolean)topicInfoTuple.getF1()).booleanValue(), sBuilder);
                            sBuilder.append("\n");
                            continue;
                        }
                        if (isOldRet) {
                            if (!bdbEntity.isValidTopicStatus()) continue;
                            sBuilder = info.toStrBuilderString(((Boolean)topicInfoTuple.getF0()).booleanValue(), ((Boolean)topicInfoTuple.getF1()).booleanValue(), sBuilder);
                            sBuilder.append("\n");
                            continue;
                        }
                        sBuilder = info.toStrBuilderString(((Boolean)topicInfoTuple.getF0()).booleanValue(), ((Boolean)topicInfoTuple.getF1()).booleanValue(), sBuilder);
                        sBuilder.append("#").append(bdbEntity.getTopicStatusId()).append("\n");
                    }
                }
                ++index;
            }
        }
    }

    private void getTopicPubInfo(HttpServletRequest req, StringBuilder sBuilder) {
        String topic = req.getParameter("topic");
        Set<String> producerIds = this.master.getTopicPSInfoManager().getTopicPubInfo(topic);
        if (producerIds != null && !producerIds.isEmpty()) {
            for (String producerId : producerIds) {
                sBuilder.append(producerId).append("\n");
            }
        } else {
            sBuilder.append("No producer has publish this topic.");
        }
    }

    private void getUnbalanceGroupInfo(StringBuilder sBuilder) {
        ConsumerInfoHolder consumerHolder = this.master.getConsumerHolder();
        BrokerRunManager brokerRunManager = this.master.getBrokerRunManager();
        ConcurrentHashMap<String, Map<String, Map<String, Partition>>> currentSubInfoMap = this.master.getCurrentSubInfoMap();
        int currPartSize = 0;
        List<String> groupList = consumerHolder.getAllServerBalanceGroups();
        for (String group : groupList) {
            if (group == null) continue;
            Set<String> topicSet = consumerHolder.getGroupTopicSet(group);
            for (String topic : topicSet) {
                List<Partition> partList;
                if (topic == null) continue;
                currPartSize = 0;
                List<String> consumerIdList = consumerHolder.getConsumerIdList(group);
                if (CollectionUtils.isNotEmpty(consumerIdList)) {
                    for (String consumerId : consumerIdList) {
                        Map topicSubInfoMap;
                        Map consumerSubInfoMap;
                        if (consumerId == null || (consumerSubInfoMap = (Map)currentSubInfoMap.get(consumerId)) == null || (topicSubInfoMap = (Map)consumerSubInfoMap.get(topic)) == null) continue;
                        currPartSize += topicSubInfoMap.size();
                    }
                }
                if (currPartSize == (partList = brokerRunManager.getSubBrokerAcceptSubParts(topic)).size()) continue;
                sBuilder.append(group).append(":").append(topic).append("\n");
            }
        }
    }
}

