/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.web.simplemvc;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.server.master.web.simplemvc.MappedContext;
import org.apache.inlong.tubemq.server.master.web.simplemvc.conf.WebConfig;

public class RequestContext
extends MappedContext {
    private final WebConfig config;
    private final HttpServletRequest req;
    private final HttpServletResponse resp;
    private String target;
    private String requestPath;
    private String requestType;
    private String redirectTarget;
    private String redirectLocation;

    public RequestContext(WebConfig config, HttpServletRequest req, HttpServletResponse resp) {
        this.config = config;
        this.req = req;
        this.resp = resp;
        this.requestPath = new StringBuilder(512).append(req.getServletPath()).append(req.getPathInfo() != null ? req.getPathInfo() : "").toString();
        if ("/".equals(this.requestPath)) {
            this.requestPath = config.getDefaultPage();
        }
        if (this.requestPath.contains(".")) {
            this.requestType = this.requestPath.substring(this.requestPath.indexOf("."));
        }
        this.target = this.getRequestTarget();
    }

    private static String normalizePath(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.indexOf(".") > -1) {
            path = path.substring(0, path.indexOf("."));
        }
        return path;
    }

    public HttpServletRequest getReq() {
        return this.req;
    }

    public HttpServletResponse getResp() {
        return this.resp;
    }

    public WebConfig getConfig() {
        return this.config;
    }

    String getParameter(String name) {
        return this.req.getParameter(name);
    }

    Cookie[] getCookies() {
        return this.req.getCookies();
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getRedirectTarget() {
        return this.redirectTarget;
    }

    public void setRedirectTarget(String redirectTarget) {
        this.redirectTarget = redirectTarget;
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    public void setRedirectLocation(String redirectLocation) {
        this.redirectLocation = redirectLocation;
    }

    boolean isRedirected() {
        return this.redirectTarget != null || this.redirectLocation != null;
    }

    public String requestType() {
        return this.requestType;
    }

    public String getRequestURI() {
        return this.req.getRequestURI();
    }

    private String getRequestTarget() {
        if (TStringUtils.isBlank((String)this.requestPath)) {
            return null;
        }
        String requestTarget = RequestContext.normalizePath(this.requestPath);
        int lastSlashIndex = requestTarget.lastIndexOf("/");
        requestTarget = lastSlashIndex >= 0 ? new StringBuilder(512).append(requestTarget.substring(0, lastSlashIndex)).append("/").append(TStringUtils.toCamelCase((String)requestTarget.substring(lastSlashIndex + 1))).toString() : TStringUtils.toCamelCase((String)requestTarget);
        return requestTarget;
    }
}

