/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.web.simplemvc.conf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.server.master.web.simplemvc.Action;

public class WebConfig {
    private final HashMap<String, Object> tools = new HashMap();
    private final HashMap<String, Action> actions = new HashMap();
    private final HashSet<String> types = new HashSet();
    private String resourcePath;
    private String templatePath;
    private String actionPackage;
    private String velocityConfigFilePath;
    private String supportedTypes = ".htm,.html";
    private String defaultPage = "index.htm";
    private boolean springSupported = false;
    private List<String> beanFilePathList = new ArrayList<String>();
    private boolean standalone = false;

    public WebConfig() {
        this.parseTypes(this.supportedTypes);
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
        if (TStringUtils.isEmpty((String)this.templatePath)) {
            this.templatePath = ("/".equals(resourcePath) ? "" : resourcePath) + "/templates";
        }
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    public String getDefaultPage() {
        return this.defaultPage;
    }

    public void setDefaultPage(String defaultPage) {
        this.defaultPage = defaultPage;
    }

    public String getActionPackage() {
        return this.actionPackage;
    }

    public void setActionPackage(String actionPackage) {
        this.actionPackage = actionPackage;
    }

    public String getVelocityConfigFilePath() {
        return this.velocityConfigFilePath;
    }

    public void setVelocityConfigFilePath(String velocityConfigFilePath) {
        this.velocityConfigFilePath = velocityConfigFilePath;
    }

    public String getSupportedTypes() {
        return this.supportedTypes;
    }

    public void setSupportedTypes(String supportedTypes) {
        this.supportedTypes = supportedTypes;
        this.parseTypes(supportedTypes);
    }

    public HashMap<String, Object> getTools() {
        return this.tools;
    }

    public HashMap<String, Action> getActions() {
        return this.actions;
    }

    public void registerAction(Action action) {
        this.actions.put(action.getClass().getName(), action);
    }

    public void registerTool(String id, Object tool) {
        this.tools.put(id, tool);
    }

    public boolean containsType(String type) {
        return this.types.contains(type);
    }

    private void parseTypes(String typePattern) {
        String[] typeArr = typePattern.split(",");
        this.types.clear();
        Collections.addAll(this.types, typeArr);
    }

    public List<String> getBeanFilePathList() {
        return this.beanFilePathList;
    }

    public void setBeanFilePathList(List<String> beanFilePathList) {
        this.beanFilePathList = beanFilePathList;
    }

    public boolean isSpringSupported() {
        return this.springSupported;
    }

    public void setSpringSupported(boolean springSupported) {
        this.springSupported = springSupported;
    }

    public boolean isStandalone() {
        return this.standalone;
    }

    public void setStandalone(boolean standalone) {
        this.standalone = standalone;
    }

    public void addBeanFilePath(String path) {
        this.beanFilePathList.add(path);
    }
}

