/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.tools.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.inlong.tubemq.server.common.fielddef.WebFieldDef;
import org.apache.inlong.tubemq.server.tools.cli.AbstractCommand;
import org.apache.inlong.tubemq.server.tools.cli.AbstractCommandRunner;
import org.apache.inlong.tubemq.server.tools.cli.CliWebapiAdmin;

@Parameters(commandDescription="Command for consumer group")
public class ConsumerGroupCommand
extends AbstractCommand {
    @Parameter
    private List<String> params;
    private static final String[] requestMethod = new String[]{"--method", ""};
    private static final Map<String, Object> requestParams = new HashMap<String, Object>();
    private static final CliWebapiAdmin cliWebapiAdmin = new CliWebapiAdmin(requestParams);

    public ConsumerGroupCommand() {
        super("group");
        this.jcommander.addCommand("list", (Object)new CgroupList());
        this.jcommander.addCommand("create", (Object)new CgroupCreate());
        this.jcommander.addCommand("delete", (Object)new CgroupDelete());
    }

    @Parameters(commandDescription="Delete consumer group")
    private static class CgroupDelete
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params = new ArrayList<String>();
        @Parameter(names={"-t", "--topic"}, order=0, required=true, description="Topic name")
        private String topicName;
        @Parameter(names={"-at", "--auth-token"}, order=1, required=true, description="Admin api operation authorization code")
        private String confModAuthToken;
        @Parameter(names={"-m", "--modifier"}, required=true, order=2, description="Record modifier")
        private String modifyUser;
        @Parameter(names={"-g", "--group"}, order=3, description="Consumer group name")
        private String groupName;

        private CgroupDelete() {
        }

        @Override
        void run() {
            try {
                requestMethod[1] = "admin_delete_allowed_consumer_group_info";
                requestParams.clear();
                if (this.topicName != null) {
                    requestParams.put(WebFieldDef.TOPICNAME.name, this.topicName);
                }
                if (this.confModAuthToken != null) {
                    requestParams.put(WebFieldDef.ADMINAUTHTOKEN.name, this.confModAuthToken);
                }
                if (this.modifyUser != null) {
                    requestParams.put(WebFieldDef.MODIFYUSER.name, this.modifyUser);
                }
                if (this.groupName != null) {
                    requestParams.put(WebFieldDef.GROUPNAME.name, this.groupName);
                }
                cliWebapiAdmin.processParams(requestMethod);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Parameters(commandDescription="Create consumer group")
    private static class CgroupCreate
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params = new ArrayList<String>();
        @Parameter(names={"-t", "--topic"}, order=0, required=true, description="Topic name")
        private String topicName;
        @Parameter(names={"-g", "--group"}, order=1, required=true, description="Consumer group name")
        private String groupName;
        @Parameter(names={"-at", "--auth-token"}, order=2, required=true, description="Admin api operation authorization code")
        private String confModAuthToken;
        @Parameter(names={"-c", "--creator"}, order=3, required=true, description="Record creator")
        private String createUser;
        @Parameter(names={"-cd", "--create-date"}, order=4, description="Record creation date")
        private String createDate;

        private CgroupCreate() {
        }

        @Override
        void run() {
            try {
                requestMethod[1] = "admin_add_authorized_consumergroup_info";
                requestParams.clear();
                if (this.topicName != null) {
                    requestParams.put(WebFieldDef.TOPICNAME.name, this.topicName);
                }
                if (this.groupName != null) {
                    requestParams.put(WebFieldDef.GROUPNAME.name, this.groupName);
                }
                if (this.confModAuthToken != null) {
                    requestParams.put(WebFieldDef.ADMINAUTHTOKEN.name, this.confModAuthToken);
                }
                if (this.createUser != null) {
                    requestParams.put(WebFieldDef.CREATEUSER.name, this.createUser);
                }
                if (this.createDate != null) {
                    requestParams.put(WebFieldDef.CREATEDATE.name, this.createDate);
                }
                cliWebapiAdmin.processParams(requestMethod);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Parameters(commandDescription="List consumer group")
    private static class CgroupList
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params = new ArrayList<String>();
        @Parameter(names={"-t", "--topic"}, order=0, description="Topic name")
        private String topicName;
        @Parameter(names={"-g", "--group"}, order=1, description="Consumer group name")
        private String groupName;
        @Parameter(names={"-c", "--creator"}, order=3, description="Record creator")
        private String createUser;

        private CgroupList() {
        }

        @Override
        void run() {
            try {
                requestMethod[1] = "admin_query_allowed_consumer_group_info";
                requestParams.clear();
                if (this.topicName != null) {
                    requestParams.put(WebFieldDef.TOPICNAME.name, this.topicName);
                }
                if (this.groupName != null) {
                    requestParams.put(WebFieldDef.GROUPNAME.name, this.groupName);
                }
                if (this.createUser != null) {
                    requestParams.put(WebFieldDef.CREATEUSER.name, this.createUser);
                }
                cliWebapiAdmin.processParams(requestMethod);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }
}

