/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Set;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.MergingSnapshotProducer;
import org.apache.iceberg.RewriteFiles;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;

class BaseRewriteFiles
extends MergingSnapshotProducer<RewriteFiles>
implements RewriteFiles {
    private final Set<DataFile> replacedDataFiles = Sets.newHashSet();
    private Long startingSnapshotId = null;

    BaseRewriteFiles(String tableName, TableOperations ops) {
        super(tableName, ops);
        this.failMissingDeletePaths();
    }

    @Override
    protected RewriteFiles self() {
        return this;
    }

    @Override
    protected String operation() {
        return "replace";
    }

    public RewriteFiles deleteFile(DataFile dataFile) {
        this.replacedDataFiles.add(dataFile);
        this.delete(dataFile);
        return this.self();
    }

    public RewriteFiles deleteFile(DeleteFile deleteFile) {
        this.delete(deleteFile);
        return this.self();
    }

    public RewriteFiles addFile(DataFile dataFile) {
        this.add(dataFile);
        return this.self();
    }

    public RewriteFiles addFile(DeleteFile deleteFile) {
        this.add(deleteFile);
        return this.self();
    }

    public RewriteFiles addFile(DeleteFile deleteFile, long dataSequenceNumber) {
        this.add(deleteFile, dataSequenceNumber);
        return this.self();
    }

    public RewriteFiles dataSequenceNumber(long sequenceNumber) {
        this.setNewDataFilesDataSequenceNumber(sequenceNumber);
        return this.self();
    }

    public RewriteFiles rewriteFiles(Set<DataFile> filesToDelete, Set<DataFile> filesToAdd, long sequenceNumber) {
        this.setNewDataFilesDataSequenceNumber(sequenceNumber);
        return this.rewriteFiles(filesToDelete, (Set<DeleteFile>)ImmutableSet.of(), filesToAdd, (Set<DeleteFile>)ImmutableSet.of());
    }

    public RewriteFiles rewriteFiles(Set<DataFile> dataFilesToReplace, Set<DeleteFile> deleteFilesToReplace, Set<DataFile> dataFilesToAdd, Set<DeleteFile> deleteFilesToAdd) {
        Preconditions.checkNotNull(dataFilesToReplace, (Object)"Replaced data files can't be null");
        Preconditions.checkNotNull(deleteFilesToReplace, (Object)"Replaced delete files can't be null");
        Preconditions.checkNotNull(dataFilesToAdd, (Object)"Added data files can't be null");
        Preconditions.checkNotNull(deleteFilesToAdd, (Object)"Added delete files can't be null");
        for (DataFile dataFile : dataFilesToReplace) {
            this.deleteFile(dataFile);
        }
        for (DeleteFile deleteFile : deleteFilesToReplace) {
            this.deleteFile(deleteFile);
        }
        for (DataFile dataFile : dataFilesToAdd) {
            this.addFile(dataFile);
        }
        for (DeleteFile deleteFile : deleteFilesToAdd) {
            this.addFile(deleteFile);
        }
        return this;
    }

    public RewriteFiles validateFromSnapshot(long snapshotId) {
        this.startingSnapshotId = snapshotId;
        return this;
    }

    public BaseRewriteFiles toBranch(String branch) {
        this.targetBranch(branch);
        return this;
    }

    @Override
    protected void validate(TableMetadata base, Snapshot parent) {
        this.validateReplacedAndAddedFiles();
        if (this.replacedDataFiles.size() > 0) {
            this.validateNoNewDeletesForDataFiles(base, this.startingSnapshotId, this.replacedDataFiles, parent);
        }
    }

    private void validateReplacedAndAddedFiles() {
        Preconditions.checkArgument((this.deletesDataFiles() || this.deletesDeleteFiles() ? 1 : 0) != 0, (Object)"Files to delete cannot be empty");
        Preconditions.checkArgument((this.deletesDataFiles() || !this.addsDataFiles() ? 1 : 0) != 0, (Object)"Data files to add must be empty because there's no data file to be rewritten");
        Preconditions.checkArgument((this.deletesDeleteFiles() || !this.addsDeleteFiles() ? 1 : 0) != 0, (Object)"Delete files to add must be empty because there's no delete file to be rewritten");
    }
}

