/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.base.Splitter;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

public class RESTUtil {
    private static final char NAMESPACE_SEPARATOR = '\u001f';
    public static final Joiner NAMESPACE_JOINER = Joiner.on((char)'\u001f');
    public static final Splitter NAMESPACE_SPLITTER = Splitter.on((char)'\u001f');
    private static final String NAMESPACE_ESCAPED_SEPARATOR = "%1F";
    private static final Joiner NAMESPACE_ESCAPED_JOINER = Joiner.on((String)"%1F");
    private static final Splitter NAMESPACE_ESCAPED_SPLITTER = Splitter.on((String)"%1F");
    private static final Joiner.MapJoiner FORM_JOINER = Joiner.on((String)"&").withKeyValueSeparator("=");
    private static final Splitter.MapSplitter FORM_SPLITTER = Splitter.on((String)"&").withKeyValueSeparator("=");

    private RESTUtil() {
    }

    public static String stripTrailingSlash(String path) {
        if (path == null) {
            return null;
        }
        String result = path;
        while (result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static Map<String, String> merge(Map<String, String> target, Map<String, String> updates) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        target.forEach((key, value) -> {
            if (!updates.containsKey(key)) {
                builder.put(key, value);
            }
        });
        updates.forEach((arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        return builder.build();
    }

    public static Map<String, String> extractPrefixMap(Map<String, String> properties, String prefix) {
        Preconditions.checkNotNull(properties, (Object)"Invalid properties map: null");
        HashMap result = Maps.newHashMap();
        properties.forEach((key, value) -> {
            if (key != null && key.startsWith(prefix)) {
                result.put(key.substring(prefix.length()), value);
            }
        });
        return result;
    }

    public static String encodeFormData(Map<?, ?> formData) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        formData.forEach((key, value) -> builder.put((Object)RESTUtil.encodeString(String.valueOf(key)), (Object)RESTUtil.encodeString(String.valueOf(value))));
        return FORM_JOINER.join((Map)builder.build());
    }

    public static Map<String, String> decodeFormData(String formString) {
        return (Map)FORM_SPLITTER.split((CharSequence)formString).entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> RESTUtil.decodeString((String)e.getKey()), e -> RESTUtil.decodeString((String)e.getValue())));
    }

    public static String encodeString(String toEncode) {
        Preconditions.checkArgument((toEncode != null ? 1 : 0) != 0, (Object)"Invalid string to encode: null");
        try {
            return URLEncoder.encode(toEncode, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedIOException(String.format("Failed to URL encode '%s': UTF-8 encoding is not supported", toEncode), e);
        }
    }

    public static String decodeString(String encoded) {
        Preconditions.checkArgument((encoded != null ? 1 : 0) != 0, (Object)"Invalid string to decode: null");
        try {
            return URLDecoder.decode(encoded, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedIOException(String.format("Failed to URL decode '%s': UTF-8 encoding is not supported", encoded), e);
        }
    }

    public static String encodeNamespace(Namespace ns) {
        Preconditions.checkArgument((ns != null ? 1 : 0) != 0, (Object)"Invalid namespace: null");
        String[] levels = ns.levels();
        Object[] encodedLevels = new String[levels.length];
        for (int i = 0; i < levels.length; ++i) {
            encodedLevels[i] = RESTUtil.encodeString(levels[i]);
        }
        return NAMESPACE_ESCAPED_JOINER.join(encodedLevels);
    }

    public static Namespace decodeNamespace(String encodedNs) {
        Preconditions.checkArgument((encodedNs != null ? 1 : 0) != 0, (Object)"Invalid namespace: null");
        String[] levels = (String[])Iterables.toArray((Iterable)NAMESPACE_ESCAPED_SPLITTER.split((CharSequence)encodedNs), String.class);
        for (int i = 0; i < levels.length; ++i) {
            levels[i] = RESTUtil.decodeString(levels[i]);
        }
        return Namespace.of((String[])levels);
    }
}

