/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.schedule.airflow.interceptor;

import java.io.IOException;
import java.util.Base64;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AirflowAuthInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(AirflowAuthInterceptor.class);
    private final String authHeader;

    public AirflowAuthInterceptor(String username, String password) {
        String credentials = username + ":" + password;
        this.authHeader = "Basic " + Base64.getEncoder().encodeToString(credentials.getBytes());
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request originalRequest = chain.request();
        Request.Builder requestBuilder = originalRequest.newBuilder().header("Authorization", this.authHeader);
        return chain.proceed(requestBuilder.build());
    }
}

