/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.pipeline.spi.Partition;
import io.debezium.util.Collect;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PostgresPartition
implements Partition {
    private static final String SERVER_PARTITION_KEY = "server";
    private final String serverName;

    public PostgresPartition(String serverName) {
        this.serverName = serverName;
    }

    public Map<String, String> getSourcePartition() {
        return Collect.hashMapOf((Object)SERVER_PARTITION_KEY, (Object)this.serverName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PostgresPartition other = (PostgresPartition)obj;
        return Objects.equals(this.serverName, other.serverName);
    }

    public int hashCode() {
        return this.serverName.hashCode();
    }

    static class Provider
    implements Partition.Provider<PostgresPartition> {
        private final PostgresConnectorConfig connectorConfig;

        Provider(PostgresConnectorConfig connectorConfig) {
            this.connectorConfig = connectorConfig;
        }

        public Set<PostgresPartition> getPartitions() {
            return Collections.singleton(new PostgresPartition(this.connectorConfig.getLogicalName()));
        }
    }
}

