/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.annotation.Immutable;
import io.debezium.connector.mongodb.MongoDbCollectionSchema;
import io.debezium.data.Envelope;
import io.debezium.pipeline.AbstractChangeRecordEmitter;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.schema.DataCollectionSchema;
import io.debezium.util.Clock;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.connect.data.Struct;
import org.bson.Document;

public class MongoDbChangeSnapshotOplogRecordEmitter
extends AbstractChangeRecordEmitter<MongoDbCollectionSchema> {
    private final Document oplogEvent;
    private final boolean isSnapshot;
    @Immutable
    private static final Map<String, Envelope.Operation> OPERATION_LITERALS;

    public MongoDbChangeSnapshotOplogRecordEmitter(Partition partition, OffsetContext offsetContext, Clock clock, Document oplogEvent, boolean isSnapshot) {
        super(partition, offsetContext, clock);
        this.oplogEvent = oplogEvent;
        this.isSnapshot = isSnapshot;
    }

    protected Envelope.Operation getOperation() {
        if (this.isSnapshot || this.oplogEvent.getString((Object)"op") == null) {
            return Envelope.Operation.READ;
        }
        return OPERATION_LITERALS.get(this.oplogEvent.getString((Object)"op"));
    }

    protected void emitReadRecord(ChangeRecordEmitter.Receiver receiver, MongoDbCollectionSchema schema) throws InterruptedException {
        Struct newKey = schema.keyFromDocument(this.oplogEvent);
        assert (newKey != null);
        Struct value = schema.valueFromDocumentOplog(this.oplogEvent, null, this.getOperation());
        value.put("source", (Object)this.getOffset().getSourceInfo());
        value.put("op", (Object)this.getOperation().code());
        value.put("ts_ms", (Object)this.getClock().currentTimeAsInstant().toEpochMilli());
        receiver.changeRecord(this.getPartition(), (DataCollectionSchema)schema, this.getOperation(), (Object)newKey, value, this.getOffset(), null);
    }

    protected void emitCreateRecord(ChangeRecordEmitter.Receiver receiver, MongoDbCollectionSchema schema) throws InterruptedException {
        this.createAndEmitChangeRecord(receiver, schema);
    }

    protected void emitUpdateRecord(ChangeRecordEmitter.Receiver receiver, MongoDbCollectionSchema schema) throws InterruptedException {
        this.createAndEmitChangeRecord(receiver, schema);
    }

    protected void emitDeleteRecord(ChangeRecordEmitter.Receiver receiver, MongoDbCollectionSchema schema) throws InterruptedException {
        this.createAndEmitChangeRecord(receiver, schema);
    }

    private void createAndEmitChangeRecord(ChangeRecordEmitter.Receiver receiver, MongoDbCollectionSchema schema) throws InterruptedException {
        Document patchObject = (Document)this.oplogEvent.get((Object)"o", Document.class);
        Document queryObject = (Document)this.oplogEvent.get((Object)"o2", Document.class);
        Document filter = queryObject != null ? queryObject : patchObject;
        Struct newKey = schema.keyFromDocument(filter);
        assert (newKey != null);
        Struct value = schema.valueFromDocumentOplog(patchObject, filter, this.getOperation());
        value.put("source", (Object)this.getOffset().getSourceInfo());
        value.put("op", (Object)this.getOperation().code());
        value.put("ts_ms", (Object)this.getClock().currentTimeAsInstant().toEpochMilli());
        receiver.changeRecord(this.getPartition(), (DataCollectionSchema)schema, this.getOperation(), (Object)newKey, value, this.getOffset(), null);
    }

    public static boolean isValidOperation(String operation) {
        return OPERATION_LITERALS.containsKey(operation);
    }

    static {
        HashMap<String, Envelope.Operation> literals = new HashMap<String, Envelope.Operation>();
        literals.put("i", Envelope.Operation.CREATE);
        literals.put("u", Envelope.Operation.UPDATE);
        literals.put("d", Envelope.Operation.DELETE);
        OPERATION_LITERALS = Collections.unmodifiableMap(literals);
    }
}

