/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.cluster.node;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.InlongClusterNodeEntity;
import org.apache.inlong.manager.pojo.cluster.ClusterNodeRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterNodeResponse;
import org.apache.inlong.manager.pojo.cluster.dataproxy.DataProxyClusterNodeDTO;
import org.apache.inlong.manager.pojo.cluster.dataproxy.DataProxyClusterNodeRequest;
import org.apache.inlong.manager.pojo.cluster.dataproxy.DataProxyClusterNodeResponse;
import org.apache.inlong.manager.service.cluster.node.AbstractClusterNodeOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataProxyClusterNodeOperator
extends AbstractClusterNodeOperator {
    private static final Logger log = LoggerFactory.getLogger(DataProxyClusterNodeOperator.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(DataProxyClusterNodeOperator.class);
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Boolean accept(String clusterNodeType) {
        return this.getClusterNodeType().equals(clusterNodeType);
    }

    @Override
    public String getClusterNodeType() {
        return "DATAPROXY";
    }

    @Override
    public ClusterNodeResponse getFromEntity(InlongClusterNodeEntity entity) {
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.CLUSTER_NOT_FOUND);
        }
        DataProxyClusterNodeResponse dataProxyClusterNodeResponse = new DataProxyClusterNodeResponse();
        CommonBeanUtils.copyProperties((Object)entity, (Object)dataProxyClusterNodeResponse);
        if (StringUtils.isNotBlank((CharSequence)entity.getExtParams())) {
            DataProxyClusterNodeDTO dto = DataProxyClusterNodeDTO.getFromJson((String)entity.getExtParams());
            CommonBeanUtils.copyProperties((Object)dto, (Object)dataProxyClusterNodeResponse);
        }
        LOGGER.debug("success to get data proxy cluster node info from entity");
        return dataProxyClusterNodeResponse;
    }

    @Override
    protected void setTargetEntity(ClusterNodeRequest request, InlongClusterNodeEntity targetEntity) {
        DataProxyClusterNodeRequest dataProxyClusterNodeRequest = (DataProxyClusterNodeRequest)request;
        CommonBeanUtils.copyProperties((Object)dataProxyClusterNodeRequest, (Object)targetEntity, (boolean)true);
        try {
            DataProxyClusterNodeDTO dto = DataProxyClusterNodeDTO.getFromRequest((DataProxyClusterNodeRequest)dataProxyClusterNodeRequest, (String)targetEntity.getExtParams());
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
            LOGGER.debug("success to set entity for data proxy cluster node");
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.CLUSTER_INFO_INCORRECT, String.format("serialize extParams of Data proxy ClusterNode failure: %s", e.getMessage()));
        }
    }
}

