/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.group;

import java.util.List;
import java.util.Optional;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.service.group.InlongGroupOperator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InlongGroupOperatorFactory {
    @Autowired
    private List<InlongGroupOperator> groupOperatorList;

    public InlongGroupOperator getInstance(String mqType) {
        Optional<InlongGroupOperator> instance = this.groupOperatorList.stream().filter(inst -> inst.accept(mqType)).findFirst();
        if (!instance.isPresent()) {
            throw new BusinessException(ErrorCodeEnum.MQ_TYPE_NOT_SUPPORTED, String.format(ErrorCodeEnum.MQ_TYPE_NOT_SUPPORTED.getMessage(), mqType));
        }
        return instance.get();
    }
}

