/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.listener;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.plugin.Plugin;
import org.apache.inlong.manager.common.plugin.PluginBinder;
import org.apache.inlong.manager.service.listener.queue.StreamQueueResourceListener;
import org.apache.inlong.manager.service.listener.sink.StreamSinkResourceListener;
import org.apache.inlong.manager.service.listener.sort.StreamSortConfigListener;
import org.apache.inlong.manager.service.listener.source.SourceStartListener;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.definition.ServiceTaskType;
import org.apache.inlong.manager.workflow.definition.TaskListenerFactory;
import org.apache.inlong.manager.workflow.event.task.QueueOperateListener;
import org.apache.inlong.manager.workflow.event.task.SinkOperateListener;
import org.apache.inlong.manager.workflow.event.task.SortOperateListener;
import org.apache.inlong.manager.workflow.event.task.SourceOperateListener;
import org.apache.inlong.manager.workflow.event.task.TaskEventListener;
import org.apache.inlong.manager.workflow.plugin.ProcessPlugin;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StreamTaskListenerFactory
implements PluginBinder,
TaskListenerFactory {
    private List<SourceOperateListener> sourceOperateListeners;
    private List<QueueOperateListener> queueOperateListeners;
    private List<SortOperateListener> sortOperateListeners;
    private List<SinkOperateListener> sinkOperateListeners;
    @Autowired
    private StreamQueueResourceListener queueResourceListener;
    @Autowired
    private StreamSortConfigListener streamSortConfigListener;
    @Autowired
    private StreamSinkResourceListener sinkResourceListener;
    @Autowired
    private SourceStartListener sourceStartListener;

    @PostConstruct
    public void init() {
        this.sourceOperateListeners = new LinkedList<SourceOperateListener>();
        this.queueOperateListeners = new LinkedList<QueueOperateListener>();
        this.queueOperateListeners.add(this.queueResourceListener);
        this.sortOperateListeners = new LinkedList<SortOperateListener>();
        this.sortOperateListeners.add(this.streamSortConfigListener);
        this.sinkOperateListeners = new LinkedList<SinkOperateListener>();
        this.sinkOperateListeners.add(this.sinkResourceListener);
        this.sourceOperateListeners.add(this.sourceStartListener);
    }

    public void acceptPlugin(Plugin plugin) {
        List pluginSinkOperateListeners;
        List pluginSortOperateListeners;
        List pluginQueueOperateListeners;
        if (!(plugin instanceof ProcessPlugin)) {
            return;
        }
        ProcessPlugin processPlugin = (ProcessPlugin)plugin;
        List pluginSourceOperateListeners = processPlugin.createSourceOperateListeners();
        if (CollectionUtils.isNotEmpty((Collection)pluginSourceOperateListeners)) {
            this.sourceOperateListeners.addAll(processPlugin.createSourceOperateListeners());
        }
        if (CollectionUtils.isNotEmpty((Collection)(pluginQueueOperateListeners = processPlugin.createQueueOperateListeners()))) {
            this.queueOperateListeners.addAll(pluginQueueOperateListeners);
        }
        if (CollectionUtils.isNotEmpty((Collection)(pluginSortOperateListeners = processPlugin.createSortOperateListeners()))) {
            this.sortOperateListeners.addAll(pluginSortOperateListeners);
        }
        if (CollectionUtils.isNotEmpty((Collection)(pluginSinkOperateListeners = processPlugin.createSinkOperateListeners()))) {
            this.sinkOperateListeners.addAll(pluginSinkOperateListeners);
        }
    }

    public List<? extends TaskEventListener> get(WorkflowContext workflowContext, ServiceTaskType taskType) {
        switch (taskType) {
            case INIT_MQ: 
            case DELETE_MQ: {
                List<QueueOperateListener> queueOperateListeners = this.getQueueOperateListener(workflowContext);
                return Lists.newArrayList(queueOperateListeners);
            }
            case INIT_SORT: 
            case STOP_SORT: 
            case RESTART_SORT: 
            case DELETE_SORT: {
                List<SortOperateListener> sortOperateListeners = this.getSortOperateListener(workflowContext);
                return Lists.newArrayList(sortOperateListeners);
            }
            case INIT_SOURCE: 
            case STOP_SOURCE: 
            case RESTART_SOURCE: 
            case DELETE_SOURCE: {
                List<SourceOperateListener> sourceOperateListeners = this.getSourceOperateListener(workflowContext);
                return Lists.newArrayList(sourceOperateListeners);
            }
            case INIT_SINK: {
                List<SinkOperateListener> sinkOperateListeners = this.getSinkOperateListener(workflowContext);
                return Lists.newArrayList(sinkOperateListeners);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported ServiceTaskType %s", taskType));
    }

    public void clearListeners() {
        this.sourceOperateListeners = new LinkedList<SourceOperateListener>();
        this.queueOperateListeners = new LinkedList<QueueOperateListener>();
        this.sortOperateListeners = new LinkedList<SortOperateListener>();
        this.sinkOperateListeners = new LinkedList<SinkOperateListener>();
    }

    public List<SourceOperateListener> getSourceOperateListener(WorkflowContext context) {
        ArrayList<SourceOperateListener> listeners = new ArrayList<SourceOperateListener>();
        for (SourceOperateListener listener : this.sourceOperateListeners) {
            if (listener == null || !listener.accept(context)) continue;
            listeners.add(listener);
        }
        return listeners;
    }

    public List<QueueOperateListener> getQueueOperateListener(WorkflowContext context) {
        ArrayList<QueueOperateListener> listeners = new ArrayList<QueueOperateListener>();
        for (QueueOperateListener listener : this.queueOperateListeners) {
            if (listener == null || !listener.accept(context)) continue;
            listeners.add(listener);
        }
        return listeners;
    }

    public List<SortOperateListener> getSortOperateListener(WorkflowContext context) {
        ArrayList<SortOperateListener> listeners = new ArrayList<SortOperateListener>();
        for (SortOperateListener listener : this.sortOperateListeners) {
            if (listener == null || !listener.accept(context)) continue;
            listeners.add(listener);
        }
        return listeners;
    }

    private List<SinkOperateListener> getSinkOperateListener(WorkflowContext context) {
        ArrayList<SinkOperateListener> listeners = new ArrayList<SinkOperateListener>();
        for (SinkOperateListener listener : this.sinkOperateListeners) {
            if (listener == null || !listener.accept(context)) continue;
            listeners.add(listener);
        }
        return listeners;
    }
}

