/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.listener.queue;

import java.util.List;
import org.apache.inlong.manager.common.enums.TaskEvent;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.pojo.group.GroupFullInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.pojo.workflow.form.process.ClusterResourceProcessForm;
import org.apache.inlong.manager.pojo.workflow.form.process.ProcessForm;
import org.apache.inlong.manager.service.resource.queue.QueueResourceOperator;
import org.apache.inlong.manager.service.resource.queue.QueueResourceOperatorFactory;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.ClusterOperateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ClusterQueueResourceListener
implements ClusterOperateListener {
    private static final Logger log = LoggerFactory.getLogger(ClusterQueueResourceListener.class);
    @Autowired
    private QueueResourceOperatorFactory queueOperatorFactory;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public boolean accept(WorkflowContext context) {
        ProcessForm processForm = context.getProcessForm();
        return processForm instanceof ClusterResourceProcessForm;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        ClusterResourceProcessForm clusterProcessForm = (ClusterResourceProcessForm)context.getProcessForm();
        log.info("begin to execute ClusterQueueResourceListener for clusterTag={},", (Object)clusterProcessForm.getInlongClusterTag());
        List groupFullInfoList = clusterProcessForm.getGroupFullInfoList();
        String operator = context.getOperator();
        for (GroupFullInfo groupFullInfo : groupFullInfoList) {
            InlongGroupInfo groupInfo = groupFullInfo.getGroupInfo();
            QueueResourceOperator queueOperator = this.queueOperatorFactory.getInstance(groupInfo.getMqType());
            queueOperator.createQueueForGroup(groupInfo, operator);
            for (InlongStreamInfo streamInfo : groupFullInfo.getStreamInfoList()) {
                queueOperator.createQueueForStream(groupInfo, streamInfo, operator);
            }
        }
        log.info("success to execute ClusterQueueResourceListener for clusterTag={}", (Object)clusterProcessForm.getInlongClusterTag());
        return ListenerResult.success((String)"success");
    }
}

