/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.message;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.enums.MessageWrapType;
import org.apache.inlong.common.pojo.sort.dataflow.deserialization.DeserializationConfig;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.pojo.consume.BriefMQMessage;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.pojo.stream.QueryMessageRequest;

public interface DeserializeOperator {
    public static final String COMPRESS_TYPE_KEY = "compressType";
    public static final String CLIENT_IP = "clientIp";
    public static final String MSG_TIME_KEY = "msgTime";
    public static final char INLONGMSG_ATTR_ENTRY_DELIMITER = '&';
    public static final char INLONGMSG_ATTR_KV_DELIMITER = '=';
    public static final String INLONGMSG_ATTR_TIME_T = "t";
    public static final String INLONGMSG_ATTR_TIME_DT = "dt";

    public boolean accept(MessageWrapType var1);

    default public List<BriefMQMessage> decodeMsg(InlongStreamInfo streamInfo, List<BriefMQMessage> briefMQMessages, byte[] msgBytes, Map<String, String> headers, int index, QueryMessageRequest request) throws Exception {
        return null;
    }

    default public DeserializationConfig getDeserializationConfig(InlongStreamInfo streamInfo) {
        throw new BusinessException(String.format("current type not support DeserializationInfo for wrapType=%s", streamInfo.getWrapType()));
    }

    default public Boolean checkIfFilter(QueryMessageRequest request, List<BriefMQMessage.FieldInfo> streamFieldList) {
        if (StringUtils.isBlank((CharSequence)request.getFieldName()) || StringUtils.isBlank((CharSequence)request.getOperationType()) || StringUtils.isBlank((CharSequence)request.getTargetValue())) {
            return false;
        }
        boolean ifFilter = false;
        BriefMQMessage.FieldInfo fieldInfo = streamFieldList.stream().filter(v -> Objects.equals(v.getFieldName(), request.getFieldName())).findFirst().orElse(null);
        if (fieldInfo != null) {
            switch (request.getOperationType()) {
                case "=": {
                    ifFilter = !Objects.equals(request.getTargetValue(), fieldInfo.getFieldValue());
                    break;
                }
                case "!=": {
                    ifFilter = Objects.equals(request.getTargetValue(), fieldInfo.getFieldValue());
                    break;
                }
                case "like": {
                    ifFilter = fieldInfo.getFieldValue() != null && !fieldInfo.getFieldValue().contains(request.getTargetValue());
                }
            }
        }
        return ifFilter;
    }
}

