/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.node.redis;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.DataNodeEntity;
import org.apache.inlong.manager.pojo.node.DataNodeInfo;
import org.apache.inlong.manager.pojo.node.DataNodeRequest;
import org.apache.inlong.manager.pojo.node.redis.RedisDataNodeDTO;
import org.apache.inlong.manager.pojo.node.redis.RedisDataNodeInfo;
import org.apache.inlong.manager.pojo.node.redis.RedisDataNodeRequest;
import org.apache.inlong.manager.pojo.sink.redis.RedisClusterMode;
import org.apache.inlong.manager.service.node.AbstractDataNodeOperator;
import org.apache.inlong.manager.service.resource.sink.redis.RedisResourceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RedisDataNodeOperator
extends AbstractDataNodeOperator {
    private static final int PORT_MAX_VALUE = 65535;
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisDataNodeOperator.class);
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Boolean accept(String dataNodeType) {
        return this.getDataNodeType().equals(dataNodeType);
    }

    @Override
    public String getDataNodeType() {
        return "REDIS";
    }

    @Override
    public DataNodeInfo getFromEntity(DataNodeEntity entity) {
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.DATA_NODE_NOT_FOUND);
        }
        RedisDataNodeInfo redisDataNodeInfo = new RedisDataNodeInfo();
        CommonBeanUtils.copyProperties((Object)entity, (Object)redisDataNodeInfo);
        if (StringUtils.isNotBlank((CharSequence)entity.getExtParams())) {
            RedisDataNodeDTO dto = RedisDataNodeDTO.getFromJson((String)entity.getExtParams());
            CommonBeanUtils.copyProperties((Object)dto, (Object)redisDataNodeInfo);
        }
        return redisDataNodeInfo;
    }

    @Override
    protected void setTargetEntity(DataNodeRequest request, DataNodeEntity targetEntity) {
        RedisDataNodeRequest redisNodeRequest = (RedisDataNodeRequest)request;
        RedisClusterMode clusterMode = RedisClusterMode.of((String)redisNodeRequest.getClusterMode());
        switch (clusterMode) {
            case STANDALONE: {
                String host = redisNodeRequest.getHost();
                Preconditions.expectNotBlank((String)host, (String)"Redis host cannot be empty");
                Integer port = redisNodeRequest.getPort();
                Preconditions.expectTrue((port != null && port > 1 && port < 65535 ? 1 : 0) != 0, (String)"The port of the redis server must be greater than 1 and less than 65535");
                break;
            }
            case SENTINEL: {
                String sentinelMasterName = redisNodeRequest.getMasterName();
                Preconditions.expectNotBlank((String)sentinelMasterName, (String)"Redis sentinel masterName cannot be empty");
                String sentinelsInfo = redisNodeRequest.getSentinelsInfo();
                Preconditions.expectNotBlank((String)sentinelsInfo, (String)"Redis sentinelsInfo cannot be empty");
                break;
            }
            case CLUSTER: {
                String clusterNodes = redisNodeRequest.getClusterNodes();
                Preconditions.expectNotBlank((String)clusterNodes, (String)"Redis clusterNodes cannot be empty");
                break;
            }
            default: {
                throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, "Unknown Redis cluster mode");
            }
        }
        CommonBeanUtils.copyProperties((Object)redisNodeRequest, (Object)targetEntity, (boolean)true);
        try {
            RedisDataNodeDTO dto = RedisDataNodeDTO.getFromRequest((RedisDataNodeRequest)redisNodeRequest, (String)targetEntity.getExtParams());
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("Failed to build extParams for Redis node: %s", e.getMessage()));
        }
    }

    @Override
    public Boolean testConnection(DataNodeRequest request) {
        RedisDataNodeRequest redisDataNodeRequest = (RedisDataNodeRequest)request;
        try {
            return RedisResourceClient.testConnection(redisDataNodeRequest);
        }
        catch (Exception e) {
            String errMsg = String.format("redis connection failed: %s ", e.getMessage());
            throw new BusinessException(errMsg);
        }
    }
}

