/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.sink.redis;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.StreamSinkEntity;
import org.apache.inlong.manager.pojo.node.redis.RedisDataNodeInfo;
import org.apache.inlong.manager.pojo.sink.SinkField;
import org.apache.inlong.manager.pojo.sink.SinkRequest;
import org.apache.inlong.manager.pojo.sink.StreamSink;
import org.apache.inlong.manager.pojo.sink.redis.RedisClusterMode;
import org.apache.inlong.manager.pojo.sink.redis.RedisDataType;
import org.apache.inlong.manager.pojo.sink.redis.RedisSchemaMapMode;
import org.apache.inlong.manager.pojo.sink.redis.RedisSink;
import org.apache.inlong.manager.pojo.sink.redis.RedisSinkDTO;
import org.apache.inlong.manager.pojo.sink.redis.RedisSinkRequest;
import org.apache.inlong.manager.service.sink.AbstractSinkOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RedisSinkOperator
extends AbstractSinkOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisSinkOperator.class);
    private static final int PORT_MAX_VALUE = 65535;
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Boolean accept(String sinkType) {
        return "REDIS".equals(sinkType);
    }

    @Override
    protected String getSinkType() {
        return "REDIS";
    }

    @Override
    protected void setTargetEntity(SinkRequest request, StreamSinkEntity targetEntity) {
        if (!this.getSinkType().equals(request.getSinkType())) {
            throw new BusinessException(ErrorCodeEnum.SINK_SAVE_FAILED, ErrorCodeEnum.SINK_TYPE_NOT_SUPPORT.getMessage() + ": " + this.getSinkType());
        }
        RedisSinkRequest sinkRequest = (RedisSinkRequest)request;
        if (StringUtils.isNotBlank((CharSequence)targetEntity.getDataNodeName())) {
            RedisDataNodeInfo dataNodeInfo = (RedisDataNodeInfo)this.dataNodeHelper.getDataNodeInfo(targetEntity.getDataNodeName(), targetEntity.getSinkType());
            CommonBeanUtils.copyProperties((Object)dataNodeInfo, (Object)sinkRequest, (boolean)true);
        }
        RedisClusterMode redisClusterMode = RedisClusterMode.of((String)sinkRequest.getClusterMode());
        Preconditions.expectNotNull((Object)redisClusterMode, (String)("Redis ClusterMode must in one of " + Arrays.toString(RedisClusterMode.values()) + " !"));
        switch (redisClusterMode) {
            case CLUSTER: {
                this.checkClusterNodes(sinkRequest.getClusterNodes());
                break;
            }
            case SENTINEL: {
                Preconditions.expectNotEmpty((String)sinkRequest.getMasterName(), (String)"Redis MasterName of Sentinel cluster must not null!");
                Preconditions.expectNotEmpty((String)sinkRequest.getSentinelsInfo(), (String)"Redis sentinelsInfo of Sentinel cluster must not null!");
                break;
            }
            case STANDALONE: {
                String host = sinkRequest.getHost();
                Integer port = sinkRequest.getPort();
                Preconditions.expectNotEmpty((String)host, (String)"Redis server host must not null!");
                Preconditions.expectTrue((port != null && port > 1 && port < 65535 ? 1 : 0) != 0, (String)"The port of the redis server must be greater than 0 and less than 65535!");
            }
        }
        RedisDataType dataType = RedisDataType.valueOf((String)sinkRequest.getDataType());
        Preconditions.expectNotNull((Object)dataType, (String)"Redis DataType must not null");
        RedisSchemaMapMode mapMode = RedisSchemaMapMode.valueOf((String)sinkRequest.getSchemaMapMode());
        Preconditions.expectTrue((boolean)dataType.getMapModes().contains(mapMode), (String)("Redis schemaMapMode '" + mapMode + "' is not supported in '" + dataType + "'"));
        try {
            RedisSinkDTO dto = RedisSinkDTO.getFromRequest((RedisSinkRequest)sinkRequest, (String)targetEntity.getExtParams());
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_SAVE_FAILED, String.format("serialize extParams of Redis SinkDTO failure: %s", e.getMessage()));
        }
    }

    private void checkClusterNodes(String clusterNodes) {
        Preconditions.expectNotBlank((String)clusterNodes, (String)"the nodes of Redis cluster must not null");
        String[] nodeArray = clusterNodes.split(",");
        Preconditions.expectNotEmpty((String[])nodeArray, (String)"the nodes of Redis cluster must not null");
        for (String node : nodeArray) {
            Preconditions.expectNotBlank((String)node, (String)"Redis server host must not null!");
            String[] ipPort = node.split(":");
            Preconditions.expectTrue((ipPort.length == 2 ? 1 : 0) != 0, (String)"The ip and port of Redis server must be in form: ip:port");
            Preconditions.expectNotBlank((String)ipPort[0], (ErrorCodeEnum)ErrorCodeEnum.IP_EMPTY);
            Preconditions.expectNotBlank((String)ipPort[1], (ErrorCodeEnum)ErrorCodeEnum.PORT_EMPTY);
        }
    }

    @Override
    public StreamSink getFromEntity(StreamSinkEntity entity) {
        RedisSink sink = new RedisSink();
        if (entity == null) {
            return sink;
        }
        RedisSinkDTO dto = RedisSinkDTO.getFromJson((String)entity.getExtParams());
        if (StringUtils.isBlank((CharSequence)dto.getHost())) {
            if (StringUtils.isBlank((CharSequence)entity.getDataNodeName())) {
                throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT, "redis data node is blank");
            }
            RedisDataNodeInfo dataNodeInfo = (RedisDataNodeInfo)this.dataNodeHelper.getDataNodeInfo(entity.getDataNodeName(), entity.getSinkType());
            CommonBeanUtils.copyProperties((Object)dataNodeInfo, (Object)dto, (boolean)true);
            String clusterMode = dataNodeInfo.getClusterMode();
            dto.setClusterMode(clusterMode);
            switch (RedisClusterMode.of((String)clusterMode)) {
                case CLUSTER: {
                    dto.setClusterNodes(dataNodeInfo.getClusterNodes());
                    break;
                }
                case SENTINEL: {
                    dto.setMasterName(dataNodeInfo.getMasterName());
                    dto.setSentinelsInfo(dataNodeInfo.getSentinelsInfo());
                    break;
                }
                case STANDALONE: {
                    dto.setHost(dataNodeInfo.getHost());
                    dto.setPort(dataNodeInfo.getPort());
                }
            }
        }
        CommonBeanUtils.copyProperties((Object)entity, (Object)sink, (boolean)true);
        CommonBeanUtils.copyProperties((Object)dto, (Object)sink, (boolean)true);
        List<SinkField> sinkFields = super.getSinkFields(entity.getId());
        sink.setSinkFieldList(sinkFields);
        return sink;
    }
}

