/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.table.catalog.AbstractCatalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotEmptyException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.FunctionAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.FunctionNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionAlreadyExistsException;
import org.apache.flink.table.catalog.exceptions.PartitionNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionSpecInvalidException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.catalog.exceptions.TableNotPartitionedException;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

public class GenericInMemoryCatalog
extends AbstractCatalog {
    public static final String DEFAULT_DB = "default";
    private final Map<String, CatalogDatabase> databases = new LinkedHashMap<String, CatalogDatabase>();
    private final Map<ObjectPath, CatalogBaseTable> tables;
    private final Map<ObjectPath, CatalogFunction> functions;
    private final Map<ObjectPath, Map<CatalogPartitionSpec, CatalogPartition>> partitions;
    private final Map<ObjectPath, CatalogTableStatistics> tableStats;
    private final Map<ObjectPath, CatalogColumnStatistics> tableColumnStats;
    private final Map<ObjectPath, Map<CatalogPartitionSpec, CatalogTableStatistics>> partitionStats;
    private final Map<ObjectPath, Map<CatalogPartitionSpec, CatalogColumnStatistics>> partitionColumnStats;

    public GenericInMemoryCatalog(String name) {
        this(name, DEFAULT_DB);
    }

    public GenericInMemoryCatalog(String name, String defaultDatabase) {
        super(name, defaultDatabase);
        this.databases.put(defaultDatabase, new CatalogDatabaseImpl(new HashMap<String, String>(), null));
        this.tables = new LinkedHashMap<ObjectPath, CatalogBaseTable>();
        this.functions = new LinkedHashMap<ObjectPath, CatalogFunction>();
        this.partitions = new LinkedHashMap<ObjectPath, Map<CatalogPartitionSpec, CatalogPartition>>();
        this.tableStats = new LinkedHashMap<ObjectPath, CatalogTableStatistics>();
        this.tableColumnStats = new LinkedHashMap<ObjectPath, CatalogColumnStatistics>();
        this.partitionStats = new LinkedHashMap<ObjectPath, Map<CatalogPartitionSpec, CatalogTableStatistics>>();
        this.partitionColumnStats = new LinkedHashMap<ObjectPath, Map<CatalogPartitionSpec, CatalogColumnStatistics>>();
    }

    public void open() {
    }

    public void close() {
    }

    public void createDatabase(String databaseName, CatalogDatabase db, boolean ignoreIfExists) throws DatabaseAlreadyExistException {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)databaseName) ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)db);
        if (this.databaseExists(databaseName)) {
            if (!ignoreIfExists) {
                throw new DatabaseAlreadyExistException(this.getName(), databaseName);
            }
        } else {
            this.databases.put(databaseName, db.copy());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dropDatabase(String databaseName, boolean ignoreIfNotExists, boolean cascade) throws DatabaseNotExistException, DatabaseNotEmptyException {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)databaseName) ? 1 : 0) != 0);
        if (this.databases.containsKey(databaseName)) {
            if (this.isDatabaseEmpty(databaseName)) {
                this.databases.remove(databaseName);
                return;
            } else {
                if (!cascade) throw new DatabaseNotEmptyException(this.getName(), databaseName);
                List<ObjectPath> deleteTablePaths = this.tables.keySet().stream().filter(op -> op.getDatabaseName().equals(databaseName)).collect(Collectors.toList());
                deleteTablePaths.forEach(objectPath -> {
                    try {
                        this.dropTable((ObjectPath)objectPath, true);
                    }
                    catch (TableNotExistException tableNotExistException) {
                        // empty catch block
                    }
                });
                List<ObjectPath> deleteFunctionPaths = this.functions.keySet().stream().filter(op -> op.getDatabaseName().equals(databaseName)).collect(Collectors.toList());
                deleteFunctionPaths.forEach(objectPath -> {
                    try {
                        this.dropFunction((ObjectPath)objectPath, true);
                    }
                    catch (FunctionNotExistException functionNotExistException) {
                        // empty catch block
                    }
                });
                this.databases.remove(databaseName);
            }
            return;
        } else {
            if (ignoreIfNotExists) return;
            throw new DatabaseNotExistException(this.getName(), databaseName);
        }
    }

    private boolean isDatabaseEmpty(String databaseName) {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)databaseName) ? 1 : 0) != 0);
        return this.tables.keySet().stream().noneMatch(op -> op.getDatabaseName().equals(databaseName)) && this.functions.keySet().stream().noneMatch(op -> op.getDatabaseName().equals(databaseName));
    }

    public void alterDatabase(String databaseName, CatalogDatabase newDatabase, boolean ignoreIfNotExists) throws DatabaseNotExistException {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)databaseName) ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)newDatabase);
        CatalogDatabase existingDatabase = this.databases.get(databaseName);
        if (existingDatabase != null) {
            if (existingDatabase.getClass() != newDatabase.getClass()) {
                throw new CatalogException(String.format("Database types don't match. Existing database is '%s' and new database is '%s'.", existingDatabase.getClass().getName(), newDatabase.getClass().getName()));
            }
            this.databases.put(databaseName, newDatabase.copy());
        } else if (!ignoreIfNotExists) {
            throw new DatabaseNotExistException(this.getName(), databaseName);
        }
    }

    public List<String> listDatabases() {
        return new ArrayList<String>(this.databases.keySet());
    }

    public CatalogDatabase getDatabase(String databaseName) throws DatabaseNotExistException {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)databaseName) ? 1 : 0) != 0);
        if (!this.databaseExists(databaseName)) {
            throw new DatabaseNotExistException(this.getName(), databaseName);
        }
        return this.databases.get(databaseName).copy();
    }

    public boolean databaseExists(String databaseName) {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)databaseName) ? 1 : 0) != 0);
        return this.databases.containsKey(databaseName);
    }

    public void createTable(ObjectPath tablePath, CatalogBaseTable table, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException {
        Preconditions.checkNotNull((Object)tablePath);
        Preconditions.checkNotNull((Object)table);
        if (!this.databaseExists(tablePath.getDatabaseName())) {
            throw new DatabaseNotExistException(this.getName(), tablePath.getDatabaseName());
        }
        if (this.tableExists(tablePath)) {
            if (!ignoreIfExists) {
                throw new TableAlreadyExistException(this.getName(), tablePath);
            }
        } else {
            this.tables.put(tablePath, table.copy());
            if (this.isPartitionedTable(tablePath)) {
                this.partitions.put(tablePath, new LinkedHashMap());
                this.partitionStats.put(tablePath, new LinkedHashMap());
                this.partitionColumnStats.put(tablePath, new LinkedHashMap());
            }
        }
    }

    public void alterTable(ObjectPath tablePath, CatalogBaseTable newTable, boolean ignoreIfNotExists) throws TableNotExistException {
        Preconditions.checkNotNull((Object)tablePath);
        Preconditions.checkNotNull((Object)newTable);
        CatalogBaseTable existingTable = this.tables.get(tablePath);
        if (existingTable != null) {
            if (existingTable.getTableKind() != newTable.getTableKind()) {
                throw new CatalogException(String.format("Table types don't match. Existing table is '%s' and new table is '%s'.", existingTable.getTableKind(), newTable.getTableKind()));
            }
            this.tables.put(tablePath, newTable.copy());
        } else if (!ignoreIfNotExists) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
    }

    public boolean supportsManagedTable() {
        return true;
    }

    public void dropTable(ObjectPath tablePath, boolean ignoreIfNotExists) throws TableNotExistException {
        Preconditions.checkNotNull((Object)tablePath);
        if (this.tableExists(tablePath)) {
            this.tables.remove(tablePath);
            this.tableStats.remove(tablePath);
            this.tableColumnStats.remove(tablePath);
            this.partitions.remove(tablePath);
            this.partitionStats.remove(tablePath);
            this.partitionColumnStats.remove(tablePath);
        } else if (!ignoreIfNotExists) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
    }

    public void renameTable(ObjectPath tablePath, String newTableName, boolean ignoreIfNotExists) throws TableNotExistException, TableAlreadyExistException {
        Preconditions.checkNotNull((Object)tablePath);
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)newTableName) ? 1 : 0) != 0);
        if (this.tableExists(tablePath)) {
            ObjectPath newPath = new ObjectPath(tablePath.getDatabaseName(), newTableName);
            if (this.tableExists(newPath)) {
                throw new TableAlreadyExistException(this.getName(), newPath);
            }
            this.tables.put(newPath, this.tables.remove(tablePath));
            if (this.tableStats.containsKey(tablePath)) {
                this.tableStats.put(newPath, this.tableStats.remove(tablePath));
            }
            if (this.tableColumnStats.containsKey(tablePath)) {
                this.tableColumnStats.put(newPath, this.tableColumnStats.remove(tablePath));
            }
            if (this.partitions.containsKey(tablePath)) {
                this.partitions.put(newPath, this.partitions.remove(tablePath));
            }
            if (this.partitionStats.containsKey(tablePath)) {
                this.partitionStats.put(newPath, this.partitionStats.remove(tablePath));
            }
            if (this.partitionColumnStats.containsKey(tablePath)) {
                this.partitionColumnStats.put(newPath, this.partitionColumnStats.remove(tablePath));
            }
        } else if (!ignoreIfNotExists) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
    }

    public List<String> listTables(String databaseName) throws DatabaseNotExistException {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)databaseName) ? 1 : 0) != 0, (Object)"databaseName cannot be null or empty");
        if (!this.databaseExists(databaseName)) {
            throw new DatabaseNotExistException(this.getName(), databaseName);
        }
        return this.tables.keySet().stream().filter(k -> k.getDatabaseName().equals(databaseName)).map(k -> k.getObjectName()).collect(Collectors.toList());
    }

    public List<String> listViews(String databaseName) throws DatabaseNotExistException {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)databaseName) ? 1 : 0) != 0, (Object)"databaseName cannot be null or empty");
        if (!this.databaseExists(databaseName)) {
            throw new DatabaseNotExistException(this.getName(), databaseName);
        }
        return this.tables.keySet().stream().filter(k -> k.getDatabaseName().equals(databaseName)).filter(k -> this.tables.get(k) instanceof CatalogView).map(k -> k.getObjectName()).collect(Collectors.toList());
    }

    public CatalogBaseTable getTable(ObjectPath tablePath) throws TableNotExistException {
        Preconditions.checkNotNull((Object)tablePath);
        if (!this.tableExists(tablePath)) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
        return this.tables.get(tablePath).copy();
    }

    public boolean tableExists(ObjectPath tablePath) {
        Preconditions.checkNotNull((Object)tablePath);
        return this.databaseExists(tablePath.getDatabaseName()) && this.tables.containsKey(tablePath);
    }

    private void ensureTableExists(ObjectPath tablePath) throws TableNotExistException {
        if (!this.tableExists(tablePath)) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
    }

    public void createFunction(ObjectPath path, CatalogFunction function, boolean ignoreIfExists) throws FunctionAlreadyExistException, DatabaseNotExistException {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)function);
        ObjectPath functionPath = this.normalize(path);
        if (!this.databaseExists(functionPath.getDatabaseName())) {
            throw new DatabaseNotExistException(this.getName(), functionPath.getDatabaseName());
        }
        if (this.functionExists(functionPath)) {
            if (!ignoreIfExists) {
                throw new FunctionAlreadyExistException(this.getName(), functionPath);
            }
        } else {
            this.functions.put(functionPath, function.copy());
        }
    }

    public void alterFunction(ObjectPath path, CatalogFunction newFunction, boolean ignoreIfNotExists) throws FunctionNotExistException {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)newFunction);
        ObjectPath functionPath = this.normalize(path);
        CatalogFunction existingFunction = this.functions.get(functionPath);
        if (existingFunction != null) {
            if (existingFunction.getClass() != newFunction.getClass()) {
                throw new CatalogException(String.format("Function types don't match. Existing function is '%s' and new function is '%s'.", existingFunction.getClass().getName(), newFunction.getClass().getName()));
            }
            this.functions.put(functionPath, newFunction.copy());
        } else if (!ignoreIfNotExists) {
            throw new FunctionNotExistException(this.getName(), functionPath);
        }
    }

    public void dropFunction(ObjectPath path, boolean ignoreIfNotExists) throws FunctionNotExistException {
        Preconditions.checkNotNull((Object)path);
        ObjectPath functionPath = this.normalize(path);
        if (this.functionExists(functionPath)) {
            this.functions.remove(functionPath);
        } else if (!ignoreIfNotExists) {
            throw new FunctionNotExistException(this.getName(), functionPath);
        }
    }

    public List<String> listFunctions(String databaseName) throws DatabaseNotExistException {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)databaseName) ? 1 : 0) != 0, (Object)"databaseName cannot be null or empty");
        if (!this.databaseExists(databaseName)) {
            throw new DatabaseNotExistException(this.getName(), databaseName);
        }
        return this.functions.keySet().stream().filter(k -> k.getDatabaseName().equals(databaseName)).map(k -> k.getObjectName()).collect(Collectors.toList());
    }

    public CatalogFunction getFunction(ObjectPath path) throws FunctionNotExistException {
        Preconditions.checkNotNull((Object)path);
        ObjectPath functionPath = this.normalize(path);
        if (!this.functionExists(functionPath)) {
            throw new FunctionNotExistException(this.getName(), functionPath);
        }
        return this.functions.get(functionPath).copy();
    }

    public boolean functionExists(ObjectPath path) {
        Preconditions.checkNotNull((Object)path);
        ObjectPath functionPath = this.normalize(path);
        return this.databaseExists(functionPath.getDatabaseName()) && this.functions.containsKey(functionPath);
    }

    private ObjectPath normalize(ObjectPath path) {
        return new ObjectPath(path.getDatabaseName(), FunctionIdentifier.normalizeName((String)path.getObjectName()));
    }

    public void createPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogPartition partition, boolean ignoreIfExists) throws TableNotExistException, TableNotPartitionedException, PartitionSpecInvalidException, PartitionAlreadyExistsException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath);
        Preconditions.checkNotNull((Object)partitionSpec);
        Preconditions.checkNotNull((Object)partition);
        this.ensureTableExists(tablePath);
        this.ensurePartitionedTable(tablePath);
        this.ensureFullPartitionSpec(tablePath, partitionSpec);
        if (this.partitionExists(tablePath, partitionSpec) && !ignoreIfExists) {
            throw new PartitionAlreadyExistsException(this.getName(), tablePath, partitionSpec);
        }
        this.partitions.get(tablePath).put(partitionSpec, partition.copy());
    }

    public void dropPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath);
        Preconditions.checkNotNull((Object)partitionSpec);
        if (this.partitionExists(tablePath, partitionSpec)) {
            this.partitions.get(tablePath).remove(partitionSpec);
            this.partitionStats.get(tablePath).remove(partitionSpec);
            this.partitionColumnStats.get(tablePath).remove(partitionSpec);
        } else if (!ignoreIfNotExists) {
            throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec);
        }
    }

    public void alterPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogPartition newPartition, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath);
        Preconditions.checkNotNull((Object)partitionSpec);
        Preconditions.checkNotNull((Object)newPartition);
        if (this.partitionExists(tablePath, partitionSpec)) {
            CatalogPartition existingPartition = this.partitions.get(tablePath).get(partitionSpec);
            if (existingPartition.getClass() != newPartition.getClass()) {
                throw new CatalogException(String.format("Partition types don't match. Existing partition is '%s' and new partition is '%s'.", existingPartition.getClass().getName(), newPartition.getClass().getName()));
            }
            this.partitions.get(tablePath).put(partitionSpec, newPartition.copy());
        } else if (!ignoreIfNotExists) {
            throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec);
        }
    }

    public List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath);
        this.ensureTableExists(tablePath);
        this.ensurePartitionedTable(tablePath);
        return new ArrayList<CatalogPartitionSpec>(this.partitions.get(tablePath).keySet());
    }

    public List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws TableNotExistException, TableNotPartitionedException, PartitionSpecInvalidException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath);
        Preconditions.checkNotNull((Object)partitionSpec);
        this.ensurePartitionedTable(tablePath);
        CatalogTable catalogTable = (CatalogTable)this.getTable(tablePath);
        List partKeys = catalogTable.getPartitionKeys();
        Map spec = partitionSpec.getPartitionSpec();
        if (!partKeys.containsAll(spec.keySet())) {
            return new ArrayList<CatalogPartitionSpec>();
        }
        return this.partitions.get(tablePath).keySet().stream().filter(ps -> ps.getPartitionSpec().entrySet().containsAll(partitionSpec.getPartitionSpec().entrySet())).collect(Collectors.toList());
    }

    public List<CatalogPartitionSpec> listPartitionsByFilter(ObjectPath tablePath, List<Expression> filters) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public CatalogPartition getPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath);
        Preconditions.checkNotNull((Object)partitionSpec);
        if (!this.partitionExists(tablePath, partitionSpec)) {
            throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec);
        }
        return this.partitions.get(tablePath).get(partitionSpec).copy();
    }

    public boolean partitionExists(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws CatalogException {
        Preconditions.checkNotNull((Object)tablePath);
        Preconditions.checkNotNull((Object)partitionSpec);
        return this.partitions.containsKey(tablePath) && this.partitions.get(tablePath).containsKey(partitionSpec);
    }

    private void ensureFullPartitionSpec(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws TableNotExistException, PartitionSpecInvalidException {
        if (!this.isFullPartitionSpec(tablePath, partitionSpec)) {
            throw new PartitionSpecInvalidException(this.getName(), ((CatalogTable)this.getTable(tablePath)).getPartitionKeys(), tablePath, partitionSpec);
        }
    }

    private boolean isFullPartitionSpec(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws TableNotExistException {
        CatalogBaseTable baseTable = this.getTable(tablePath);
        if (!(baseTable instanceof CatalogTable)) {
            return false;
        }
        CatalogTable table = (CatalogTable)baseTable;
        List partitionKeys = table.getPartitionKeys();
        Map spec = partitionSpec.getPartitionSpec();
        return partitionKeys.size() == spec.size() && spec.keySet().containsAll(partitionKeys);
    }

    private void ensurePartitionedTable(ObjectPath tablePath) throws TableNotPartitionedException {
        if (!this.isPartitionedTable(tablePath)) {
            throw new TableNotPartitionedException(this.getName(), tablePath);
        }
    }

    private boolean isPartitionedTable(ObjectPath tablePath) {
        CatalogBaseTable table = null;
        try {
            table = this.getTable(tablePath);
        }
        catch (TableNotExistException e) {
            return false;
        }
        return table instanceof CatalogTable && ((CatalogTable)table).isPartitioned();
    }

    public CatalogTableStatistics getTableStatistics(ObjectPath tablePath) throws TableNotExistException {
        Preconditions.checkNotNull((Object)tablePath);
        if (!this.tableExists(tablePath)) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
        if (!this.isPartitionedTable(tablePath)) {
            CatalogTableStatistics result = this.tableStats.get(tablePath);
            return result != null ? result.copy() : CatalogTableStatistics.UNKNOWN;
        }
        return CatalogTableStatistics.UNKNOWN;
    }

    public CatalogColumnStatistics getTableColumnStatistics(ObjectPath tablePath) throws TableNotExistException {
        Preconditions.checkNotNull((Object)tablePath);
        if (!this.tableExists(tablePath)) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
        CatalogColumnStatistics result = this.tableColumnStats.get(tablePath);
        return result != null ? result.copy() : CatalogColumnStatistics.UNKNOWN;
    }

    public CatalogTableStatistics getPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException {
        Preconditions.checkNotNull((Object)tablePath);
        Preconditions.checkNotNull((Object)partitionSpec);
        if (!this.partitionExists(tablePath, partitionSpec)) {
            throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec);
        }
        CatalogTableStatistics result = this.partitionStats.get(tablePath).get(partitionSpec);
        return result != null ? result.copy() : CatalogTableStatistics.UNKNOWN;
    }

    public CatalogColumnStatistics getPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException {
        Preconditions.checkNotNull((Object)tablePath);
        Preconditions.checkNotNull((Object)partitionSpec);
        if (!this.partitionExists(tablePath, partitionSpec)) {
            throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec);
        }
        CatalogColumnStatistics result = this.partitionColumnStats.get(tablePath).get(partitionSpec);
        return result != null ? result.copy() : CatalogColumnStatistics.UNKNOWN;
    }

    public void alterTableStatistics(ObjectPath tablePath, CatalogTableStatistics tableStatistics, boolean ignoreIfNotExists) throws TableNotExistException {
        Preconditions.checkNotNull((Object)tablePath);
        Preconditions.checkNotNull((Object)tableStatistics);
        if (this.tableExists(tablePath)) {
            this.tableStats.put(tablePath, tableStatistics.copy());
        } else if (!ignoreIfNotExists) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
    }

    public void alterTableColumnStatistics(ObjectPath tablePath, CatalogColumnStatistics columnStatistics, boolean ignoreIfNotExists) throws TableNotExistException {
        Preconditions.checkNotNull((Object)tablePath);
        Preconditions.checkNotNull((Object)columnStatistics);
        if (this.tableExists(tablePath)) {
            this.tableColumnStats.put(tablePath, columnStatistics.copy());
        } else if (!ignoreIfNotExists) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
    }

    public void alterPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogTableStatistics partitionStatistics, boolean ignoreIfNotExists) throws PartitionNotExistException {
        Preconditions.checkNotNull((Object)tablePath);
        Preconditions.checkNotNull((Object)partitionSpec);
        Preconditions.checkNotNull((Object)partitionStatistics);
        if (this.partitionExists(tablePath, partitionSpec)) {
            this.partitionStats.get(tablePath).put(partitionSpec, partitionStatistics.copy());
        } else if (!ignoreIfNotExists) {
            throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec);
        }
    }

    public void alterPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogColumnStatistics columnStatistics, boolean ignoreIfNotExists) throws PartitionNotExistException {
        Preconditions.checkNotNull((Object)tablePath);
        Preconditions.checkNotNull((Object)partitionSpec);
        Preconditions.checkNotNull((Object)columnStatistics);
        if (this.partitionExists(tablePath, partitionSpec)) {
            this.partitionColumnStats.get(tablePath).put(partitionSpec, columnStatistics.copy());
        } else if (!ignoreIfNotExists) {
            throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec);
        }
    }
}

