/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.node.extract;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.node.ExtractNode;
import org.apache.inlong.sort.protocol.transformation.WatermarkField;

@JsonTypeName(value="dorisExtract")
public class DorisExtractNode
extends ExtractNode
implements Serializable {
    private static final long serialVersionUID = -1369223293553991653L;
    @JsonProperty(value="feNodes")
    @Nonnull
    private String feNodes;
    @JsonProperty(value="username")
    @Nonnull
    private String userName;
    @JsonProperty(value="password")
    @Nonnull
    private String password;
    @JsonProperty(value="tableIdentifier")
    @Nonnull
    private String tableIdentifier;

    @JsonCreator
    public DorisExtractNode(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="fields") List<FieldInfo> fields, @Nullable @JsonProperty(value="watermarkField") WatermarkField waterMarkField, @JsonProperty(value="properties") Map<String, String> properties, @JsonProperty(value="feNodes") @Nonnull String feNodes, @JsonProperty(value="username") String userName, @JsonProperty(value="password") String password, @JsonProperty(value="tableIdentifier") String tableIdentifier) {
        super(id, name, fields, waterMarkField, properties);
        this.feNodes = (String)Preconditions.checkNotNull((Object)feNodes, (Object)"feNodes is null");
        this.userName = (String)Preconditions.checkNotNull((Object)userName, (Object)"username is null");
        this.password = (String)Preconditions.checkNotNull((Object)password, (Object)"password is null");
        this.tableIdentifier = (String)Preconditions.checkNotNull((Object)tableIdentifier, (Object)"tableIdentifier is null");
    }

    @Override
    public Map<String, String> tableOptions() {
        Map<String, String> options = super.tableOptions();
        options.put("connector", "doris");
        options.put("fenodes", this.feNodes);
        options.put("username", this.userName);
        options.put("password", this.password);
        options.put("table.identifier", this.tableIdentifier);
        return options;
    }

    @Override
    public String genTableName() {
        return String.format("table_%s", super.getId());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DorisExtractNode)) {
            return false;
        }
        DorisExtractNode other = (DorisExtractNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$feNodes = this.getFeNodes();
        String other$feNodes = other.getFeNodes();
        if (this$feNodes == null ? other$feNodes != null : !this$feNodes.equals(other$feNodes)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$tableIdentifier = this.getTableIdentifier();
        String other$tableIdentifier = other.getTableIdentifier();
        return !(this$tableIdentifier == null ? other$tableIdentifier != null : !this$tableIdentifier.equals(other$tableIdentifier));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DorisExtractNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $feNodes = this.getFeNodes();
        result = result * 59 + ($feNodes == null ? 43 : $feNodes.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $tableIdentifier = this.getTableIdentifier();
        result = result * 59 + ($tableIdentifier == null ? 43 : $tableIdentifier.hashCode());
        return result;
    }

    @Nonnull
    public String getFeNodes() {
        return this.feNodes;
    }

    @Nonnull
    public String getUserName() {
        return this.userName;
    }

    @Nonnull
    public String getPassword() {
        return this.password;
    }

    @Nonnull
    public String getTableIdentifier() {
        return this.tableIdentifier;
    }

    public void setFeNodes(@Nonnull String feNodes) {
        if (feNodes == null) {
            throw new NullPointerException("feNodes is marked non-null but is null");
        }
        this.feNodes = feNodes;
    }

    public void setUserName(@Nonnull String userName) {
        if (userName == null) {
            throw new NullPointerException("userName is marked non-null but is null");
        }
        this.userName = userName;
    }

    public void setPassword(@Nonnull String password) {
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
        this.password = password;
    }

    public void setTableIdentifier(@Nonnull String tableIdentifier) {
        if (tableIdentifier == null) {
            throw new NullPointerException("tableIdentifier is marked non-null but is null");
        }
        this.tableIdentifier = tableIdentifier;
    }

    @Override
    public String toString() {
        return "DorisExtractNode(feNodes=" + this.getFeNodes() + ", userName=" + this.getUserName() + ", password=" + this.getPassword() + ", tableIdentifier=" + this.getTableIdentifier() + ")";
    }
}

