/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.decode;

import java.nio.charset.Charset;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.sdk.transform.decode.CsvSourceData;
import org.apache.inlong.sdk.transform.decode.KvUtils;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.decode.SourceDecoder;
import org.apache.inlong.sdk.transform.pojo.CsvSourceInfo;
import org.apache.inlong.sdk.transform.pojo.FieldInfo;
import org.apache.inlong.sdk.transform.process.Context;

public class CsvSourceDecoder
extends SourceDecoder<String> {
    protected CsvSourceInfo sourceInfo;
    private Charset srcCharset = Charset.defaultCharset();
    private Character delimiter = Character.valueOf('|');
    private Character escapeChar = null;

    public CsvSourceDecoder(CsvSourceInfo sourceInfo) {
        super(sourceInfo.getFields());
        this.sourceInfo = sourceInfo;
        if (sourceInfo.getDelimiter() != null) {
            this.delimiter = sourceInfo.getDelimiter();
        }
        if (sourceInfo.getEscapeChar() != null) {
            this.escapeChar = sourceInfo.getEscapeChar();
        }
        if (!StringUtils.isBlank((CharSequence)sourceInfo.getCharset())) {
            this.srcCharset = Charset.forName(sourceInfo.getCharset());
        }
    }

    @Override
    public SourceData decode(byte[] srcBytes, Context context) {
        String srcString = new String(srcBytes, this.srcCharset);
        return this.decode(srcString, context);
    }

    @Override
    public SourceData decode(String srcString, Context context) {
        String[][] rowValues = KvUtils.splitCsv(srcString, this.delimiter, this.escapeChar, null, Character.valueOf('\n'), false);
        CsvSourceData sourceData = new CsvSourceData(context);
        for (int i = 0; i < rowValues.length; ++i) {
            String[] fieldValues = rowValues[i];
            sourceData.addRow();
            if (CollectionUtils.isEmpty((Collection)this.fields)) {
                for (int j = 0; j < fieldValues.length; ++j) {
                    String fieldName = "$" + (j + 1);
                    sourceData.putField(fieldName, fieldValues[j]);
                }
                continue;
            }
            int fieldIndex = 0;
            for (FieldInfo field : this.fields) {
                String fieldName = field.getName();
                Object fieldValue = null;
                if (fieldIndex < fieldValues.length) {
                    try {
                        fieldValue = field.getConverter().convert(fieldValues[fieldIndex]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                sourceData.putField(fieldName, fieldValue);
                ++fieldIndex;
            }
        }
        return sourceData;
    }
}

