/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.decode;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.sdk.transform.decode.AbstractSourceData;
import org.apache.inlong.sdk.transform.decode.PbNode;
import org.apache.inlong.sdk.transform.process.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PbSourceData
extends AbstractSourceData {
    private static final Logger LOG = LoggerFactory.getLogger(PbSourceData.class);
    public static final String ROOT_KEY = "$root.";
    public static final String CHILD_KEY = "$child.";
    private Descriptors.Descriptor rootDesc;
    private Descriptors.Descriptor childDesc;
    private Map<String, List<PbNode>> columnNodeMap = new ConcurrentHashMap<String, List<PbNode>>();
    private DynamicMessage root;
    private List<DynamicMessage> childRoot;
    private Charset srcCharset;

    public PbSourceData(DynamicMessage root, List<DynamicMessage> childRoot, Descriptors.Descriptor rootDesc, Descriptors.Descriptor childDesc, Map<String, List<PbNode>> columnNodeMap, Charset srcCharset, Context context) {
        this.root = root;
        this.childRoot = childRoot;
        this.rootDesc = rootDesc;
        this.childDesc = childDesc;
        this.columnNodeMap = columnNodeMap;
        this.srcCharset = srcCharset;
        this.context = context;
    }

    public PbSourceData(DynamicMessage root, Descriptors.Descriptor rootDesc, Map<String, List<PbNode>> columnNodeMap, Charset srcCharset) {
        this.root = root;
        this.rootDesc = rootDesc;
        this.columnNodeMap = columnNodeMap;
        this.srcCharset = srcCharset;
    }

    @Override
    public int getRowCount() {
        if (this.childRoot == null) {
            return 1;
        }
        return this.childRoot.size();
    }

    @Override
    public String getField(int rowNum, String fieldName) {
        String fieldValue = "";
        try {
            if (this.isContextField(fieldName)) {
                return this.getContextField(fieldName);
            }
            if (StringUtils.startsWith((CharSequence)fieldName, (CharSequence)ROOT_KEY)) {
                fieldValue = this.getRootField(fieldName);
            } else if (StringUtils.startsWith((CharSequence)fieldName, (CharSequence)CHILD_KEY) && this.childRoot != null && rowNum < this.childRoot.size()) {
                fieldValue = this.getChildField(rowNum, fieldName);
            }
            return fieldValue;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return fieldValue;
        }
    }

    private String getRootField(String srcFieldName) {
        List<PbNode> childNodes = this.columnNodeMap.get(srcFieldName);
        if (childNodes == null) {
            String fieldName = srcFieldName.substring(ROOT_KEY.length());
            childNodes = PbNode.parseNodePath(this.rootDesc, fieldName);
            if (childNodes == null) {
                childNodes = new ArrayList<PbNode>();
            }
            this.columnNodeMap.put(srcFieldName, childNodes);
        }
        if (childNodes.size() == 0) {
            return "";
        }
        String fieldValue = this.getNodeValue(childNodes, this.root);
        return fieldValue;
    }

    private String getChildField(int rowNum, String srcFieldName) {
        if (this.childRoot == null || this.childDesc == null) {
            return "";
        }
        List<PbNode> childNodes = this.columnNodeMap.get(srcFieldName);
        if (childNodes == null) {
            String fieldName = srcFieldName.substring(CHILD_KEY.length());
            childNodes = PbNode.parseNodePath(this.childDesc, fieldName);
            if (childNodes == null) {
                childNodes = new ArrayList<PbNode>();
            }
            this.columnNodeMap.put(srcFieldName, childNodes);
        }
        if (childNodes.size() == 0) {
            return "";
        }
        DynamicMessage child = this.childRoot.get(rowNum);
        String fieldValue = this.getNodeValue(childNodes, child);
        return fieldValue;
    }

    private String getNodeValue(List<PbNode> childNodes, DynamicMessage root) {
        PbNode node;
        Object nodeValue;
        String fieldValue = "";
        DynamicMessage current = root;
        for (int i = 0; i < childNodes.size() && (nodeValue = current.getField((node = childNodes.get(i)).getFieldDesc())) != null; ++i) {
            Object nodeElement;
            if (node.isLastNode()) {
                switch (node.getFieldDesc().getJavaType()) {
                    case STRING: 
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: 
                    case BOOLEAN: {
                        fieldValue = String.valueOf(nodeValue);
                        break;
                    }
                    case BYTE_STRING: {
                        ByteString byteString = (ByteString)nodeValue;
                        fieldValue = new String(byteString.toByteArray(), this.srcCharset);
                        break;
                    }
                    case ENUM: {
                        fieldValue = String.valueOf(nodeValue);
                        break;
                    }
                    case MESSAGE: {
                        fieldValue = String.valueOf(nodeValue);
                    }
                }
                break;
            }
            if (!node.isArray()) {
                if (!(nodeValue instanceof DynamicMessage)) break;
                current = (DynamicMessage)nodeValue;
                continue;
            }
            if (!(nodeValue instanceof List)) break;
            List nodeList = (List)nodeValue;
            if (node.getArrayIndex() >= nodeList.size() || !((nodeElement = nodeList.get(node.getArrayIndex())) instanceof DynamicMessage)) break;
            current = (DynamicMessage)nodeElement;
        }
        return fieldValue;
    }
}

