/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.encode;

import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.sdk.transform.encode.SinkData;
import org.apache.inlong.sdk.transform.encode.SinkEncoder;
import org.apache.inlong.sdk.transform.pojo.FieldInfo;
import org.apache.inlong.sdk.transform.pojo.KvSinkInfo;
import org.apache.inlong.sdk.transform.process.Context;

public class KvSinkEncoder
extends SinkEncoder<String> {
    protected KvSinkInfo sinkInfo;
    protected Charset sinkCharset = Charset.defaultCharset();
    private Character entryDelimiter = Character.valueOf('&');
    private Character kvDelimiter = Character.valueOf('=');
    private StringBuilder builder = new StringBuilder();

    public KvSinkEncoder(KvSinkInfo sinkInfo) {
        super(sinkInfo.getFields());
        this.sinkInfo = sinkInfo;
        if (!StringUtils.isBlank((CharSequence)sinkInfo.getCharset())) {
            this.sinkCharset = Charset.forName(sinkInfo.getCharset());
        }
        if (sinkInfo.getEntryDelimiter() != null) {
            this.entryDelimiter = sinkInfo.getEntryDelimiter();
        }
        if (sinkInfo.getKvDelimiter() != null) {
            this.kvDelimiter = sinkInfo.getKvDelimiter();
        }
    }

    @Override
    public String encode(SinkData sinkData, Context context) {
        this.builder.delete(0, this.builder.length());
        if (this.fields == null || this.fields.size() == 0) {
            for (String fieldName : sinkData.keyList()) {
                String fieldValue = sinkData.getField(fieldName);
                if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"*")) {
                    this.builder.append(fieldValue).append(this.entryDelimiter);
                    continue;
                }
                this.builder.append(fieldName).append(this.kvDelimiter).append(fieldValue).append(this.entryDelimiter);
            }
        } else {
            for (FieldInfo field : this.fields) {
                String fieldName = field.getName();
                String fieldValue = sinkData.getField(fieldName);
                this.builder.append(fieldName).append(this.kvDelimiter).append(fieldValue).append(this.entryDelimiter);
            }
        }
        return this.builder.substring(0, this.builder.length() - 1);
    }
}

