/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.encode;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.inlong.sdk.transform.encode.SinkData;
import org.apache.inlong.sdk.transform.encode.SinkEncoder;
import org.apache.inlong.sdk.transform.pojo.FieldInfo;
import org.apache.inlong.sdk.transform.pojo.MapSinkInfo;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.converter.TypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapSinkEncoder
extends SinkEncoder<Map<String, Object>> {
    private static final Logger log = LoggerFactory.getLogger(MapSinkEncoder.class);
    private final MapSinkInfo sinkInfo;
    private final Map<String, TypeConverter> converters;

    public MapSinkEncoder(MapSinkInfo sinkInfo) {
        super(sinkInfo.getFields());
        this.sinkInfo = sinkInfo;
        this.converters = sinkInfo.getFields().stream().collect(Collectors.toMap(FieldInfo::getName, info -> info.getConverter() == null ? TypeConverter.DefaultTypeConverter() : info.getConverter()));
    }

    @Override
    public Map<String, Object> encode(SinkData sinkData, Context context) {
        HashMap<String, Object> esMap = new HashMap<String, Object>();
        for (FieldInfo fieldInfo : this.fields) {
            String fieldName = fieldInfo.getName();
            String strValue = sinkData.getField(fieldName);
            TypeConverter converter = this.converters.get(fieldName);
            if (converter == null) {
                esMap.put(fieldName, strValue);
                continue;
            }
            try {
                esMap.put(fieldName, converter.convert(strValue));
            }
            catch (Throwable t) {
                esMap.put(fieldName, null);
            }
        }
        return esMap;
    }
}

