/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.collection;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="collection", names={"map"}, parameter="([String value1, String value2, ...])", descriptions={"- Return \"\" if the number of parameters is not even;", "- Return a map created from a list of key-value pairs ((value1, value2), ... )."}, examples={"Map('he',7,'xxd') = null", "Map('he',1,'xxd','cloud') = {he=1, xxd=cloud}", "Map('xxd','cloud',map(1,2),map(3,'apple')) = {xxd=cloud, {1=2}={3=apple}}"})
public class MapFunction
implements ValueParser {
    private List<ValueParser> parserList;

    public MapFunction(Function expr) {
        if (expr.getParameters() == null) {
            this.parserList = new ArrayList<ValueParser>();
        } else {
            List params = expr.getParameters().getExpressions();
            this.parserList = new ArrayList<ValueParser>(params.size());
            for (Expression param : params) {
                ValueParser node = OperatorTools.buildParser(param);
                this.parserList.add(node);
            }
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        if (this.parserList.size() % 2 != 0) {
            throw new IllegalArgumentException("Input values must be in key-value pairs.");
        }
        LinkedHashMap<Object, Object> res = new LinkedHashMap<Object, Object>();
        for (int i = 0; i < this.parserList.size(); i += 2) {
            Object key = this.parserList.get(i).parse(sourceData, rowIndex, context);
            Object value = this.parserList.get(i + 1).parse(sourceData, rowIndex, context);
            res.put(key, value);
        }
        return res;
    }
}

