/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.compression.factory;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.inlong.sdk.transform.process.function.compression.handler.DeflaterUncompress;
import org.apache.inlong.sdk.transform.process.function.compression.handler.GzipUncompress;
import org.apache.inlong.sdk.transform.process.function.compression.handler.UncompressHandler;
import org.apache.inlong.sdk.transform.process.function.compression.handler.ZipUncompress;

public class UnCompressionAlgorithmFactory {
    private static Map<String, UncompressHandler> unCompressMap = new ConcurrentHashMap<String, UncompressHandler>();

    public static UncompressHandler getCompressHandlerByName(String name) {
        return unCompressMap.get(name);
    }

    static {
        unCompressMap.put("deflater", new DeflaterUncompress());
        unCompressMap.put("gzip", new GzipUncompress());
        unCompressMap.put("zip", new ZipUncompress());
    }
}

