/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="string", names={"printf"}, parameter="(String strfmt [, Object obj, ...])", descriptions={"- Return a formatted string from printf-style format strings."}, examples={"printf(\"User %s has %d points and a balance of %.2f.\", \"Bob\", 1500, 99.99) = \" User Bob has 1500 points and a balance of 99.99.\""})
public class PrintfFunction
implements ValueParser {
    private ValueParser strfmtParser;
    private List<ValueParser> argsParser = new ArrayList<ValueParser>();

    public PrintfFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.strfmtParser = OperatorTools.buildParser((Expression)expressions.get(0));
        for (int i = 1; i < expressions.size(); ++i) {
            this.argsParser.add(OperatorTools.buildParser((Expression)expressions.get(i)));
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object strfmtObj = this.strfmtParser.parse(sourceData, rowIndex, context);
        String strfmt = OperatorTools.parseString(strfmtObj);
        int size = this.argsParser.size();
        Object[] args = new Object[size];
        for (int i = 0; i < size; ++i) {
            Object parsed = this.argsParser.get(i).parse(sourceData, rowIndex, context);
            String arg = parsed == null ? "null" : parsed.toString();
            args[i] = this.parse(arg);
        }
        return String.format(strfmt, args);
    }

    public Object parse(Object obj) {
        if (this.isInteger(obj)) {
            obj = Integer.parseInt(obj.toString());
        } else if (this.isFloat(obj)) {
            obj = Float.valueOf(Float.parseFloat(obj.toString()));
        }
        return obj;
    }

    public boolean isFloat(Object obj) {
        return obj.toString().matches("^(-?\\d+)(\\.\\d+)?$");
    }

    public boolean isInteger(Object obj) {
        return obj.toString().matches("^-?\\d+$");
    }
}

